/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import com.connectina.swing.fontchooser.JFontChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.visualization.collapse.LabelAttributesPanel;
import org.gephi.ui.appearance.plugin.UniqueLabelColorTransformerUI;
import org.gephi.ui.appearance.plugin.category.DefaultCategory;
import org.gephi.visualization.api.LabelColorMode;
import org.gephi.visualization.api.LabelSizeMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EdgeLabelsSettingsPanel
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private JButton attributesButton;
    private JComboBox<LabelColorMode> edgeColorCombo;
    private JButton edgeFontButton;
    private JComboBox<LabelSizeMode> edgeSizeCombo;
    private JSlider edgeSizeSlider;
    private JCheckBox hideNonSelectedCheckbox;
    private JLabel labelEdgeColor;
    private JLabel labelEdgeFont;
    private JLabel labelEdgeScale;
    private JLabel labelEdgeSize;
    private JXHyperlink selfColorLink;
    private JCheckBox showLabelsCheckbox;

    public EdgeLabelsSettingsPanel() {
        this.initComponents();
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        DefaultComboBoxModel<LabelColorMode> colorModeModel = new DefaultComboBoxModel<LabelColorMode>(LabelColorMode.values());
        this.edgeColorCombo.setModel(colorModeModel);
        this.edgeColorCombo.addActionListener(e -> {
            LabelColorMode selected = (LabelColorMode)this.edgeColorCombo.getSelectedItem();
            if (selected == null) {
                return;
            }
            this.vizController.setEdgeLabelColorMode(selected);
            this.selfColorLink.setVisible(selected.equals((Object)LabelColorMode.SELF));
        });
        this.edgeColorCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof LabelColorMode)) {
                    throw new IllegalArgumentException("Expected LabelColorMode");
                }
                label.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)("EdgeLabelColorMode." + ((LabelColorMode)value).name().toLowerCase() + ".name")));
                label.setIcon(ImageUtilities.loadIcon((String)("VisualizationImpl/LabelColorMode_" + ((LabelColorMode)value).name() + ".svg")));
                return this;
            }
        });
        this.selfColorLink.addActionListener(e -> {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("AppearanceTopComponent");
            topComponent.open();
            topComponent.requestActive();
            AppearanceUIController appearanceUIController = (AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class);
            TransformerCategory category = DefaultCategory.LABEL_COLOR;
            appearanceUIController.setSelectedElementClass("edges");
            appearanceUIController.setSelectedCategory(category);
            UniqueLabelColorTransformerUI transformerUI = (UniqueLabelColorTransformerUI)Lookup.getDefault().lookup(UniqueLabelColorTransformerUI.class);
            appearanceUIController.setSelectedTransformerUI((TransformerUI)transformerUI);
        });
        DefaultComboBoxModel<LabelSizeMode> sizeModeModel = new DefaultComboBoxModel<LabelSizeMode>(LabelSizeMode.values());
        this.edgeSizeCombo.setModel(sizeModeModel);
        this.edgeSizeCombo.addActionListener(e -> this.vizController.setEdgeLabelSizeMode((LabelSizeMode)this.edgeSizeCombo.getSelectedItem()));
        this.edgeSizeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof LabelSizeMode)) {
                    throw new IllegalArgumentException("Expected NodeLabelSizeMode");
                }
                label.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)("LabelSizeMode." + ((LabelSizeMode)value).name().toLowerCase() + ".name")));
                label.setIcon(ImageUtilities.loadIcon((String)("VisualizationImpl/LabelSizeMode_" + ((LabelSizeMode)value).name() + ".svg")));
                return this;
            }
        });
        this.showLabelsCheckbox.addItemListener(e -> {
            this.vizController.setShowEdgeLabels(this.showLabelsCheckbox.isSelected());
            this.setEnable(true);
        });
        this.edgeFontButton.addActionListener(e -> {
            VisualizationModel model = this.vizController.getModel();
            Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)model.getEdgeLabelFont());
            if (font != null && font != model.getEdgeLabelFont()) {
                this.vizController.setEdgeLabelFont(font);
            }
        });
        this.edgeSizeSlider.addChangeListener(e -> this.vizController.setEdgeLabelScale((float)this.edgeSizeSlider.getValue() / 100.0f));
        this.attributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationModel model = EdgeLabelsSettingsPanel.this.vizController.getModel();
                LabelAttributesPanel panel = new LabelAttributesPanel(model, true);
                panel.setup();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"LabelAttributesPanel.title"), true, 2, null, null);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    panel.unsetup();
                }
            }
        });
        this.attributesButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/configureLabels.svg", (boolean)false));
        this.hideNonSelectedCheckbox.addActionListener(e -> this.vizController.setHideNonSelectedEdgeLabels(this.hideNonSelectedCheckbox.isSelected()));
    }

    public void setup(VisualizationModel model) {
        if (model == null) {
            this.setEnable(false);
            return;
        }
        this.refreshSharedConfig(model);
        this.setEnable(true);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void unsetup(VisualizationModel model) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showEdgeLabels")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeLabelFont")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeLabelScale")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("hideNonSelectedEdgeLabels")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeLabelSizeMode")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeLabelColorMode")) {
            this.refreshSharedConfig(model);
        }
    }

    private void refreshSharedConfig(VisualizationModel vizModel) {
        if (this.showLabelsCheckbox.isSelected() != vizModel.isShowEdgeLabels()) {
            this.showLabelsCheckbox.setSelected(vizModel.isShowEdgeLabels());
        }
        if (this.edgeColorCombo.getSelectedItem() != vizModel.getEdgeLabelColorMode()) {
            this.edgeColorCombo.setSelectedItem(vizModel.getEdgeLabelColorMode());
        }
        if (this.edgeSizeCombo.getSelectedItem() != vizModel.getEdgeLabelSizeMode()) {
            this.edgeSizeCombo.setSelectedItem(vizModel.getEdgeLabelSizeMode());
        }
        this.edgeFontButton.setText(vizModel.getEdgeLabelFont().getFontName() + ", " + vizModel.getEdgeLabelFont().getSize());
        if ((float)this.edgeSizeSlider.getValue() / 100.0f != vizModel.getEdgeLabelScale()) {
            this.edgeSizeSlider.setValue((int)(vizModel.getEdgeLabelScale() * 100.0f));
        }
        if (this.hideNonSelectedCheckbox.isSelected() != vizModel.isHideNonSelectedEdgeLabels()) {
            this.hideNonSelectedCheckbox.setSelected(vizModel.isHideNonSelectedEdgeLabels());
        }
        this.selfColorLink.setVisible(this.edgeColorCombo.getSelectedItem() == LabelColorMode.SELF);
    }

    private void setEnable(boolean enable) {
        this.showLabelsCheckbox.setEnabled(enable);
        this.edgeColorCombo.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelEdgeColor.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.edgeFontButton.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelEdgeFont.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.edgeSizeSlider.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelEdgeScale.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.edgeSizeCombo.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelEdgeSize.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.hideNonSelectedCheckbox.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.attributesButton.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.selfColorLink.setEnabled(enable && this.showLabelsCheckbox.isSelected());
    }

    private void initComponents() {
        this.showLabelsCheckbox = new JCheckBox();
        this.labelEdgeColor = new JLabel();
        this.edgeColorCombo = new JComboBox();
        this.labelEdgeFont = new JLabel();
        this.edgeFontButton = new JButton();
        this.labelEdgeScale = new JLabel();
        this.edgeSizeSlider = new JSlider();
        this.labelEdgeSize = new JLabel();
        this.edgeSizeCombo = new JComboBox();
        this.hideNonSelectedCheckbox = new JCheckBox();
        this.attributesButton = new JButton();
        this.selfColorLink = new JXHyperlink();
        this.showLabelsCheckbox.setFont(new Font("Tahoma", 1, 11));
        this.showLabelsCheckbox.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.showLabelsCheckbox.text"));
        this.labelEdgeColor.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.labelEdgeColor.text"));
        this.labelEdgeFont.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.labelEdgeFont.text"));
        this.labelEdgeFont.setMaximumSize(new Dimension(60, 15));
        this.edgeFontButton.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.edgeFontButton.text"));
        this.labelEdgeScale.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.labelEdgeScale.text"));
        this.edgeSizeSlider.setMinimum(1);
        this.labelEdgeSize.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.labelEdgeSize.text"));
        this.hideNonSelectedCheckbox.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.hideNonSelectedCheckbox.text"));
        this.hideNonSelectedCheckbox.setBorder(null);
        this.hideNonSelectedCheckbox.setHorizontalTextPosition(2);
        this.hideNonSelectedCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.attributesButton.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.attributesButton.text"));
        this.selfColorLink.setText(NbBundle.getMessage(EdgeLabelsSettingsPanel.class, (String)"EdgeLabelsSettingsPanel.selfColorLink.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelEdgeColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeColorCombo, -2, 145, -2)).addGroup(layout.createSequentialGroup().addComponent(this.labelEdgeSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.edgeSizeCombo, -2, 145, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selfColorLink, -2, 31, -2).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.labelEdgeFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeFontButton, -1, -1, Short.MAX_VALUE)).addComponent(this.hideNonSelectedCheckbox)).addGap(18, 18, 18).addComponent(this.labelEdgeScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeSizeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributesButton, -2, 125, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCheckbox))).addContainerGap(99, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelEdgeColor).addComponent(this.edgeColorCombo, -2, -1, -2).addComponent(this.labelEdgeFont, -2, -1, -2).addComponent(this.edgeFontButton).addComponent(this.labelEdgeScale).addComponent(this.edgeSizeSlider, -2, -1, -2).addComponent((Component)this.selfColorLink, -2, -1, -2).addComponent(this.attributesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelEdgeSize).addComponent(this.edgeSizeCombo, -2, -1, -2).addComponent(this.hideNonSelectedCheckbox)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

