/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.desktop.visualization.collapse.EdgeLabelsSettingsPanel;
import org.gephi.desktop.visualization.collapse.LabelAttributesPanel;
import org.gephi.ui.components.JPopupButton;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.LabelColorMode;
import org.gephi.visualization.api.LabelSizeMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeLabelGroup
implements CollapseGroup,
VisualizationPropertyChangeListener {
    private final JToggleButton showLabelsButton;
    private final JPopupButton labelColorModeButton;
    private final JPopupButton labelSizeModeButton;
    private final JButton attributesButton;
    private final JSlider fontSizeSlider;
    private final VisualizationController vizController;
    private final EdgeLabelsSettingsPanel edgeLabelsSettingsPanel = new EdgeLabelsSettingsPanel();

    public EdgeLabelGroup() {
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        this.showLabelsButton = new JToggleButton();
        this.showLabelsButton.setToolTipText(NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.Edges.showLabels"));
        this.showLabelsButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/showEdgeLabels.svg", (boolean)false));
        this.showLabelsButton.addActionListener(e -> this.vizController.setShowEdgeLabels(this.showLabelsButton.isSelected()));
        this.attributesButton = new JButton();
        this.attributesButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/configureLabels.svg", (boolean)false));
        this.attributesButton.setToolTipText(NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.Labels.attributes"));
        this.attributesButton.addActionListener(e -> {
            VisualizationModel model = this.vizController.getModel();
            LabelAttributesPanel panel = new LabelAttributesPanel(model, true);
            panel.setup();
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(EdgeLabelGroup.class, (String)"LabelAttributesPanel.title"), true, 2, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                panel.unsetup();
            }
        });
        this.labelColorModeButton = new JPopupButton();
        for (LabelColorMode labelColorMode : LabelColorMode.values()) {
            this.labelColorModeButton.addItem((Object)labelColorMode, (Icon)ImageUtilities.loadImageIcon((String)("VisualizationImpl/LabelColorMode_" + labelColorMode.name() + ".svg"), (boolean)false), NbBundle.getMessage(EdgeLabelGroup.class, (String)("EdgeLabelColorMode." + labelColorMode.name().toLowerCase() + ".name")));
        }
        this.labelColorModeButton.setChangeListener(e -> this.vizController.setEdgeLabelColorMode((LabelColorMode)e.getSource()));
        this.labelColorModeButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/labelColorMode.svg", (boolean)false));
        this.labelColorModeButton.setToolTipText(NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.Labels.colorMode"));
        this.labelSizeModeButton = new JPopupButton();
        for (LabelColorMode labelColorMode : LabelSizeMode.values()) {
            this.labelSizeModeButton.addItem((Object)labelColorMode, (Icon)ImageUtilities.loadImageIcon((String)("VisualizationImpl/LabelSizeMode_" + labelColorMode.name() + ".svg"), (boolean)false), NbBundle.getMessage(EdgeLabelGroup.class, (String)("LabelSizeMode." + labelColorMode.name().toLowerCase() + ".name")));
        }
        this.labelSizeModeButton.setChangeListener(e -> this.vizController.setEdgeLabelSizeMode((LabelSizeMode)e.getSource()));
        this.labelSizeModeButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/labelSizeMode.svg", (boolean)false));
        this.labelSizeModeButton.setToolTipText(NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.Labels.sizeMode"));
        this.fontSizeSlider = new JSlider(1, 100, 1);
        this.fontSizeSlider.setToolTipText(NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.Labels.fontScale"));
        this.fontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EdgeLabelGroup.this.vizController.setEdgeLabelScale((float)EdgeLabelGroup.this.fontSizeSlider.getValue() / 100.0f);
            }
        });
        this.fontSizeSlider.setPreferredSize(new Dimension(100, 20));
        this.fontSizeSlider.setMaximumSize(new Dimension(100, 20));
    }

    @Override
    public void setup(VizModel vizModel) {
        this.edgeLabelsSettingsPanel.setup(vizModel);
        this.showLabelsButton.setSelected(vizModel.isShowEdgeLabels());
        this.labelColorModeButton.setSelectedItem((Object)vizModel.getEdgeLabelColorMode());
        this.labelSizeModeButton.setSelectedItem((Object)vizModel.getEdgeLabelSizeMode());
        this.fontSizeSlider.setValue((int)(vizModel.getEdgeLabelScale() * 100.0f));
        this.refreshEnable(true);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    private void refreshEnable(boolean enabled) {
        this.showLabelsButton.setEnabled(enabled);
        boolean showLabels = enabled && this.showLabelsButton.isSelected();
        this.labelColorModeButton.setEnabled(showLabels);
        this.labelSizeModeButton.setEnabled(showLabels);
        this.attributesButton.setEnabled(showLabels);
        this.fontSizeSlider.setEnabled(showLabels);
    }

    @Override
    public void unsetup(VizModel vizModel) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
        this.edgeLabelsSettingsPanel.unsetup(vizModel);
    }

    @Override
    public void disable() {
        this.refreshEnable(false);
        this.edgeLabelsSettingsPanel.setup(null);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if ("showEdgeLabels".equals(evt.getPropertyName())) {
            this.showLabelsButton.setSelected((Boolean)evt.getNewValue());
            this.refreshEnable(true);
        } else if ("edgeLabelColorMode".equals(evt.getPropertyName())) {
            this.labelColorModeButton.setSelectedItem((Object)model.getEdgeLabelColorMode());
        } else if ("edgeLabelSizeMode".equals(evt.getPropertyName())) {
            this.labelSizeModeButton.setSelectedItem((Object)model.getEdgeLabelSizeMode());
        } else if ("edgeLabelScale".equals(evt.getPropertyName())) {
            float scale = ((Float)evt.getNewValue()).floatValue();
            int sliderValue = (int)(scale * 100.0f);
            if (this.fontSizeSlider.getValue() != sliderValue) {
                this.fontSizeSlider.setValue(sliderValue);
            }
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EdgeLabelGroup.class, (String)"VizToolbar.EdgeLabels.groupBarTitle");
    }

    @Override
    public JComponent[] getToolbarComponents() {
        return new JComponent[]{this.showLabelsButton, this.labelColorModeButton, this.labelSizeModeButton, this.fontSizeSlider};
    }

    @Override
    public JComponent getExtendedComponent() {
        return this.edgeLabelsSettingsPanel;
    }

    @Override
    public boolean hasToolbar() {
        return true;
    }

    @Override
    public boolean hasExtended() {
        return true;
    }

    @Override
    public boolean drawSeparator() {
        return false;
    }
}

