/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.desktop.visualization.collapse.EdgeSettingsPanel;
import org.gephi.ui.components.JPopupButton;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.EdgeColorMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeGroup
implements CollapseGroup,
VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private final EdgeSettingsPanel edgeSettingsPanel = new EdgeSettingsPanel();
    private final JToggleButton showEdgeButton;
    private final JSlider edgeScaleSlider;
    private final JPopupButton edgeColorModeButton;
    private final JLabel titleLabel;

    public EdgeGroup() {
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        this.titleLabel = new JLabel(NbBundle.getMessage(EdgeGroup.class, (String)"VizToolbar.Edges.groupLabel"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.showEdgeButton = new JToggleButton();
        this.showEdgeButton.setToolTipText(NbBundle.getMessage(EdgeGroup.class, (String)"VizToolbar.Edges.showEdges"));
        this.showEdgeButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/showEdges.svg", (boolean)false));
        this.showEdgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeGroup.this.vizController.setShowEdges(EdgeGroup.this.showEdgeButton.isSelected());
            }
        });
        this.edgeColorModeButton = new JPopupButton();
        for (EdgeColorMode mode : EdgeColorMode.values()) {
            this.edgeColorModeButton.addItem((Object)mode, (Icon)ImageUtilities.loadImageIcon((String)("VisualizationImpl/EdgeColorMode_" + mode.name() + ".svg"), (boolean)false), NbBundle.getMessage(EdgeGroup.class, (String)("EdgeColorMode." + mode.name().toLowerCase() + ".name")));
        }
        this.edgeColorModeButton.setChangeListener(e -> this.vizController.setEdgeColorMode((EdgeColorMode)e.getSource()));
        this.edgeColorModeButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/edgeColorMode.svg", (boolean)false));
        this.edgeColorModeButton.setToolTipText(NbBundle.getMessage(EdgeGroup.class, (String)"VizToolbar.Edges.colorMode"));
        this.edgeScaleSlider = new JSlider(1, 100, 1);
        this.edgeScaleSlider.setToolTipText(NbBundle.getMessage(EdgeGroup.class, (String)"VizToolbar.Edges.edgeScale"));
        this.edgeScaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float value = (float)EdgeGroup.this.edgeScaleSlider.getValue() / 10.0f + 0.1f;
                EdgeGroup.this.vizController.setEdgeScale(value);
            }
        });
        this.edgeScaleSlider.setPreferredSize(new Dimension(100, 20));
        this.edgeScaleSlider.setMaximumSize(new Dimension(100, 20));
    }

    @Override
    public void setup(VizModel vizModel) {
        this.edgeSettingsPanel.setup(vizModel);
        this.titleLabel.setEnabled(true);
        this.edgeColorModeButton.setEnabled(true);
        this.edgeColorModeButton.setSelectedItem((Object)vizModel.getEdgeColorMode());
        this.showEdgeButton.setEnabled(true);
        this.showEdgeButton.setSelected(vizModel.isShowEdges());
        this.edgeScaleSlider.setEnabled(true);
        this.edgeScaleSlider.setValue((int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    @Override
    public void unsetup(VizModel vizModel) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
        this.edgeSettingsPanel.unsetup(vizModel);
    }

    @Override
    public void disable() {
        this.edgeSettingsPanel.setup(null);
        for (JComponent component : this.getToolbarComponents()) {
            component.setEnabled(false);
        }
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showEdges")) {
            if (this.showEdgeButton.isSelected() != model.isShowEdges()) {
                this.showEdgeButton.setSelected(model.isShowEdges());
            }
        } else if (evt.getPropertyName().equals("edgeScale")) {
            if (model.getEdgeScale() != (float)this.edgeScaleSlider.getValue() / 10.0f + 0.1f) {
                this.edgeScaleSlider.setValue((int)((model.getEdgeScale() - 0.1f) * 10.0f));
            }
        } else if (evt.getPropertyName().equals("edgeColorMode") && this.edgeColorModeButton.getSelectedItem() != model.getEdgeColorMode()) {
            this.edgeColorModeButton.setSelectedItem((Object)model.getEdgeColorMode());
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EdgeGroup.class, (String)"VizToolbar.Edges.groupBarTitle");
    }

    @Override
    public JComponent[] getToolbarComponents() {
        return new JComponent[]{this.titleLabel, this.showEdgeButton, this.edgeScaleSlider, this.edgeColorModeButton};
    }

    @Override
    public JComponent getExtendedComponent() {
        return this.edgeSettingsPanel;
    }

    @Override
    public boolean hasToolbar() {
        return true;
    }

    @Override
    public boolean hasExtended() {
        return true;
    }
}

