/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.filter;

import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.desktop.search.api.SearchController;
import org.gephi.desktop.search.api.SearchRequest;
import org.gephi.desktop.search.api.SearchResult;
import org.gephi.desktop.search.filter.SearchPanel;
import org.gephi.desktop.search.impl.SearchCategoryImpl;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SearchFilterBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.ATTRIBUTES;
    }

    public String getName() {
        return NbBundle.getMessage(SearchFilterBuilder.class, (String)"SearchFilterBuilder.name");
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DesktopSearch/search.svg", (boolean)false);
    }

    public String getDescription() {
        return NbBundle.getMessage(SearchFilterBuilder.class, (String)"SearchFilterBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new SearchFilter();
    }

    public JPanel getPanel(Filter filter) {
        SearchPanel panel = new SearchPanel();
        panel.setup((SearchFilter)filter);
        return panel;
    }

    public void destroy(Filter filter) {
    }

    public static class SearchFilter
    implements ComplexFilter {
        private String query;
        private String type = SearchCategoryImpl.NODES().getId();

        public Graph filter(Graph graph) {
            if (this.query == null || this.query.isEmpty()) {
                return graph;
            }
            SearchRequest request = SearchRequest.builder().query(this.query).graph(graph).parallel(false).limitResults(false).build();
            SearchController searchController = (SearchController)Lookup.getDefault().lookup(SearchController.class);
            Subgraph subgraph = graph.getModel().getGraph(graph.getView());
            if (this.type.equalsIgnoreCase(SearchCategoryImpl.NODES().getId())) {
                List nodes = searchController.search(request, Node.class).stream().map(SearchResult::getResult).collect(Collectors.toList());
                subgraph.retainNodes(nodes);
            } else if (this.type.equalsIgnoreCase(SearchCategoryImpl.EDGES().getId())) {
                List edges = searchController.search(request, Edge.class).stream().map(SearchResult::getResult).collect(Collectors.toList());
                subgraph.retainEdges(edges);
            }
            return subgraph;
        }

        public String getName() {
            return NbBundle.getMessage(SearchFilterBuilder.class, (String)"SearchFilter.name");
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty((Filter)this, String.class, (String)"query"), FilterProperty.createProperty((Filter)this, String.class, (String)"type")};
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FilterProperty[0];
            }
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

