/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.gephi.desktop.search.SearchDialog;
import org.gephi.desktop.search.SearchUIModel;
import org.gephi.project.api.ProjectController;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class SearchAction
extends AbstractAction {
    private final SearchUIModel uiModel = new SearchUIModel();

    SearchAction() {
        super(NbBundle.getMessage(SearchAction.class, (String)"CTL_Search"), ImageUtilities.loadImageIcon((String)"DesktopSearch/search.svg", (boolean)false));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.isEnabled()) {
            final SearchDialog panel = new SearchDialog(this.uiModel);
            final JDialog dialog = new JDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SearchAction.class, (String)"SearchDialog.title"), false);
            dialog.getRootPane().registerKeyboardAction(e -> this.closeDialog(panel, dialog), KeyStroke.getKeyStroke(27, 0), 2);
            dialog.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    SearchAction.this.closeDialog(panel, dialog);
                }
            });
            panel.instrumentDragListener(dialog);
            dialog.setUndecorated(true);
            dialog.getContentPane().add(panel);
            dialog.setBounds(212, 237, 679, 378);
            dialog.setVisible(true);
        }
    }

    private void closeDialog(SearchDialog panel, JDialog dialog) {
        SwingUtilities.invokeLater(() -> {
            panel.unsetup();
            dialog.dispose();
        });
    }

    @Override
    public boolean isEnabled() {
        return ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).hasCurrentProject();
    }
}

