/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.lib.validation.PositiveNumberValidator;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DynamicSettingsPanel
extends JPanel {
    private final String DAYS = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.TimeUnit.DAYS");
    private final String HOURS = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.TimeUnit.HOURS");
    private final String MILLISECONDS = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.TimeUnit.MILLISECONDS");
    private final String MINUTES = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.TimeUnit.MINUTES");
    private final String SECONDS = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.TimeUnit.SECONDS");
    private TimeUnit windowTimeUnit = TimeUnit.DAYS;
    private TimeUnit tickTimeUnit = TimeUnit.DAYS;
    private Interval bounds = null;
    private JLabel currentIntervalLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel labelCurrentTimeline;
    private JTextField tickTextField;
    private JComboBox tickTimeUnitCombo;
    private JLabel windowInfoLabel;
    private JTextField windowTextField;
    private JComboBox windowTimeUnitCombo;

    public DynamicSettingsPanel() {
        this.initComponents();
        this.windowTimeUnitCombo.setModel(this.getTimeUnitModel());
        this.tickTimeUnitCombo.setModel(this.getTimeUnitModel());
        this.windowInfoLabel.addMouseListener(new MouseAdapter(){
            RichTooltip richTooltip;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DynamicSettingsPanel.this.windowInfoLabel.isEnabled()) {
                    this.richTooltip = DynamicSettingsPanel.this.buildTooltip();
                    Point screenLocation = new Point(e.getLocationOnScreen().x, e.getLocationOnScreen().y + DynamicSettingsPanel.this.windowInfoLabel.getHeight());
                    this.richTooltip.showTooltip((JComponent)DynamicSettingsPanel.this.windowInfoLabel, screenLocation);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.richTooltip != null) {
                    this.richTooltip.hideTooltip();
                    this.richTooltip = null;
                }
            }
        });
    }

    public static JPanel createCounpoundPanel(DynamicSettingsPanel dynamicPanel, JPanel innerPanel) {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        result.add((Component)dynamicPanel, gridBagConstraints);
        if (innerPanel != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            result.add((Component)innerPanel, gridBagConstraints);
        }
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)result);
        ValidationGroup group = validationPanel.getValidationGroup();
        dynamicPanel.createValidation(group);
        return validationPanel;
    }

    public void setup(DynamicStatistics dynamicStatistics) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel();
        TimeFormat timeFormat = graphModel.getTimeFormat();
        GraphView currentView = graphModel.getVisibleView();
        this.bounds = currentView.isMainView() ? graphModel.getTimeBounds() : currentView.getTimeInterval();
        String boundsStr = timeFormat.print(this.bounds.getLow()) + " - " + timeFormat.print(this.bounds.getHigh());
        this.currentIntervalLabel.setText(boundsStr);
        if (timeFormat.equals((Object)TimeFormat.DOUBLE)) {
            this.windowTimeUnitCombo.setVisible(false);
            this.tickTimeUnitCombo.setVisible(false);
        }
        if (!timeFormat.equals((Object)TimeFormat.DOUBLE)) {
            this.loadDefaultTimeUnits();
        }
        double initValue = 0.0;
        if (this.bounds.getHigh() - this.bounds.getLow() > 1.0) {
            initValue = 1.0;
        }
        if (timeFormat.equals((Object)TimeFormat.DOUBLE)) {
            this.windowTextField.setText("" + initValue);
            this.tickTextField.setText("" + initValue);
        } else {
            this.windowTextField.setText("" + this.windowTimeUnit.convert((long)initValue, TimeUnit.MILLISECONDS));
            this.tickTextField.setText("" + this.tickTimeUnit.convert((long)initValue, TimeUnit.MILLISECONDS));
        }
        this.windowTimeUnitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() != DynamicSettingsPanel.this.windowTimeUnitCombo.getSelectedItem()) {
                    DynamicSettingsPanel.this.refreshWindowTimeUnit();
                }
            }
        });
        this.tickTimeUnitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() != DynamicSettingsPanel.this.tickTimeUnitCombo.getSelectedItem()) {
                    DynamicSettingsPanel.this.refreshTickTimeUnit();
                }
            }
        });
    }

    public void unsetup(DynamicStatistics dynamicStatistics) {
        double tick;
        double window;
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel();
        TimeFormat timeFormat = graphModel.getTimeFormat();
        dynamicStatistics.setBounds(this.bounds);
        if (timeFormat == TimeFormat.DOUBLE) {
            window = Double.parseDouble(this.windowTextField.getText());
        } else {
            TimeUnit timeUnit = this.getSelectedTimeUnit(this.windowTimeUnitCombo.getModel());
            window = this.getTimeInMilliseconds(this.windowTextField.getText(), timeUnit);
        }
        dynamicStatistics.setWindow(window);
        if (timeFormat == TimeFormat.DOUBLE) {
            tick = Double.parseDouble(this.tickTextField.getText());
        } else {
            TimeUnit timeUnit = this.getSelectedTimeUnit(this.tickTimeUnitCombo.getModel());
            tick = this.getTimeInMilliseconds(this.tickTextField.getText(), timeUnit);
        }
        dynamicStatistics.setTick(tick);
        if (timeFormat != TimeFormat.DOUBLE) {
            this.saveDefaultTimeUnits();
        }
    }

    public void createValidation(ValidationGroup group) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel();
        TimeFormat timeFormat = graphModel.getTimeFormat();
        if (timeFormat == TimeFormat.DOUBLE) {
            group.add((Object)this.windowTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.numberRange((Number)Double.MIN_VALUE, (Number)(this.bounds.getHigh() - this.bounds.getLow()))});
            group.add((Object)this.tickTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.numberRange((Number)Double.MIN_VALUE, (Number)(this.bounds.getHigh() - this.bounds.getLow()))});
        } else {
            group.add((Object)this.windowTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new PositiveNumberValidator(), new DateRangeValidator(this.windowTimeUnitCombo.getModel())});
            group.add((Object)this.tickTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new PositiveNumberValidator(), new DateRangeValidator(this.tickTimeUnitCombo.getModel()), new TickUnderWindowValidator(timeFormat != TimeFormat.DOUBLE)});
        }
    }

    private ComboBoxModel getTimeUnitModel() {
        return new DefaultComboBoxModel<String>(new String[]{this.DAYS, this.HOURS, this.MILLISECONDS, this.MINUTES, this.SECONDS});
    }

    private TimeUnit getSelectedTimeUnit(ComboBoxModel comboBoxModel) {
        if (comboBoxModel.getSelectedItem().equals(this.DAYS)) {
            return TimeUnit.DAYS;
        }
        if (comboBoxModel.getSelectedItem().equals(this.HOURS)) {
            return TimeUnit.HOURS;
        }
        if (comboBoxModel.getSelectedItem().equals(this.MILLISECONDS)) {
            return TimeUnit.MILLISECONDS;
        }
        if (comboBoxModel.getSelectedItem().equals(this.MINUTES)) {
            return TimeUnit.MINUTES;
        }
        if (comboBoxModel.getSelectedItem().equals(this.SECONDS)) {
            return TimeUnit.SECONDS;
        }
        return null;
    }

    private double getTimeInMilliseconds(String text, TimeUnit timeUnit) {
        Integer t = Integer.parseInt(text);
        return TimeUnit.MILLISECONDS.convert(t.intValue(), timeUnit);
    }

    private void refreshWindowTimeUnit() {
        TimeUnit tu = this.getSelectedTimeUnit(this.windowTimeUnitCombo.getModel());
        try {
            Integer value = Integer.parseInt(this.windowTextField.getText());
            long newValue = tu.convert(value.intValue(), this.windowTimeUnit);
            this.windowTextField.setText("" + newValue);
            this.windowTimeUnit = tu;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshTickTimeUnit() {
        TimeUnit tu = this.getSelectedTimeUnit(this.tickTimeUnitCombo.getModel());
        try {
            Integer value = Integer.parseInt(this.tickTextField.getText());
            long newValue = tu.convert(value.intValue(), this.tickTimeUnit);
            this.tickTextField.setText("" + newValue);
            this.tickTimeUnit = tu;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadDefaultTimeUnits() {
        String windowDuration = NbPreferences.forModule(DynamicSettingsPanel.class).get("DynamicSettingsPanel_window_timeunit", this.windowTimeUnit.name());
        this.windowTimeUnit = TimeUnit.valueOf(windowDuration);
        String tickDuration = NbPreferences.forModule(DynamicSettingsPanel.class).get("DynamicSettingsPanel_tick_timeunit", this.tickTimeUnit.name());
        this.tickTimeUnit = TimeUnit.valueOf(tickDuration);
        this.windowTimeUnitCombo.setSelectedItem(this.getTimeUnit(this.windowTimeUnit));
        this.tickTimeUnitCombo.setSelectedItem(this.getTimeUnit(this.tickTimeUnit));
    }

    private void saveDefaultTimeUnits() {
        NbPreferences.forModule(DynamicSettingsPanel.class).put("DynamicSettingsPanel_window_timeunit", this.windowTimeUnit.name());
        NbPreferences.forModule(DynamicSettingsPanel.class).put("DynamicSettingsPanel_tick_timeunit", this.tickTimeUnit.name());
    }

    private String getTimeUnit(TimeUnit timeUnit) {
        if (timeUnit.equals((Object)TimeUnit.DAYS)) {
            return this.DAYS;
        }
        if (timeUnit.equals((Object)TimeUnit.HOURS)) {
            return this.HOURS;
        }
        if (timeUnit.equals((Object)TimeUnit.MILLISECONDS)) {
            return this.MILLISECONDS;
        }
        if (timeUnit.equals((Object)TimeUnit.MINUTES)) {
            return this.MINUTES;
        }
        if (timeUnit.equals((Object)TimeUnit.SECONDS)) {
            return this.SECONDS;
        }
        return null;
    }

    private RichTooltip buildTooltip() {
        String name = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.infoLabel.name");
        String description = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.infoLabel.description");
        RichTooltip richTooltip = new RichTooltip(name, description);
        Image image = ImageUtilities.loadImage((String)"DesktopStatistics/infolabel_details.png", (boolean)false);
        richTooltip.setMainImage(image);
        return richTooltip;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.labelCurrentTimeline = new JLabel();
        this.currentIntervalLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tickTextField = new JTextField();
        this.windowTextField = new JTextField();
        this.windowTimeUnitCombo = new JComboBox();
        this.tickTimeUnitCombo = new JComboBox();
        this.windowInfoLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.jPanel1.border.title")));
        this.labelCurrentTimeline.setText(NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.labelCurrentTimeline.text"));
        this.jLabel1.setText(NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DynamicSettingsPanel.jLabel2.text"));
        this.tickTextField.setName("tick");
        this.windowTextField.setName("window");
        this.windowInfoLabel.setIcon(ImageUtilities.loadImageIcon((String)"DesktopStatistics/info.svg", (boolean)false));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tickTextField).addComponent(this.windowTextField, -2, 89, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tickTimeUnitCombo, 0, -1, Short.MAX_VALUE).addComponent(this.windowTimeUnitCombo, -2, 109, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.labelCurrentTimeline).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentIntervalLabel, -2, 199, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 61, Short.MAX_VALUE).addComponent(this.windowInfoLabel))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelCurrentTimeline).addComponent(this.currentIntervalLabel, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.windowTextField, -2, -1, -2).addComponent(this.windowTimeUnitCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tickTextField, -2, -1, -2).addComponent(this.tickTimeUnitCombo, -2, -1, -2))).addComponent(this.windowInfoLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private class DateRangeValidator
    implements Validator<String> {
        private final ComboBoxModel combo;

        public DateRangeValidator(ComboBoxModel comboBoxModel) {
            this.combo = comboBoxModel;
        }

        public void validate(Problems prblms, String string, String t) {
            Integer i = 0;
            try {
                i = Integer.parseInt(t);
            }
            catch (NumberFormatException e) {
                prblms.add("Number can't be parsed");
            }
            TimeUnit tu = DynamicSettingsPanel.this.getSelectedTimeUnit(this.combo);
            long timeInMilli = (long)DynamicSettingsPanel.this.getTimeInMilliseconds(t, tu);
            long limit = (long)(DynamicSettingsPanel.this.bounds.getHigh() - DynamicSettingsPanel.this.bounds.getLow());
            if (i < 1 || timeInMilli > limit) {
                String message = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"DateRangeValidator.NotInRange", (Object)i, (Object)1, (Object)tu.convert(limit, TimeUnit.MILLISECONDS));
                prblms.add(message);
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }

    private class TickUnderWindowValidator
    implements Validator<String> {
        private final boolean dates;

        public TickUnderWindowValidator(boolean dates) {
            this.dates = dates;
        }

        public void validate(Problems prblms, String string, String t) {
            if (this.dates) {
                Integer tick = 0;
                Integer window = 0;
                try {
                    tick = Integer.parseInt(t);
                    window = Integer.parseInt(DynamicSettingsPanel.this.windowTextField.getText());
                }
                catch (NumberFormatException e) {
                    prblms.add("Number can't be parsed");
                }
                TimeUnit tu = DynamicSettingsPanel.this.getSelectedTimeUnit(DynamicSettingsPanel.this.tickTimeUnitCombo.getModel());
                long tickInMilli = (long)DynamicSettingsPanel.this.getTimeInMilliseconds(t, tu);
                tu = DynamicSettingsPanel.this.getSelectedTimeUnit(DynamicSettingsPanel.this.windowTimeUnitCombo.getModel());
                long windowInMilli = (long)DynamicSettingsPanel.this.getTimeInMilliseconds(DynamicSettingsPanel.this.windowTextField.getText(), tu);
                if (tickInMilli > windowInMilli) {
                    String message = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"TickUnderWindowValidator.OverWindow");
                    prblms.add(message);
                }
            } else {
                Double tick = 0.0;
                Double window = 0.0;
                try {
                    tick = Double.parseDouble(t);
                    window = Double.parseDouble(DynamicSettingsPanel.this.windowTextField.getText());
                }
                catch (NumberFormatException e) {
                    prblms.add("Number can't be parsed");
                }
                if (tick > window) {
                    String message = NbBundle.getMessage(DynamicSettingsPanel.class, (String)"TickUnderWindowValidator.OverWindow");
                    prblms.add(message);
                }
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }
}

