/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.Report;
import org.gephi.ui.components.BusyUtils;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ProcessorIssuesReportPanel
extends JPanel {
    private static final String SHOW_ISSUES = "ProcessorIssuesReportPanel_Show_Issues";
    private static final String SHOW_REPORT = "ProcessorIssuesReportPanel_Show_Report";
    private static final int ISSUES_LIMIT = 5000;
    private final ThreadGroup fillingThreads;
    private ImageIcon infoIcon;
    private ImageIcon warningIcon;
    private ImageIcon severeIcon;
    private ImageIcon criticalIcon;
    private Outline issuesOutline;
    private JEditorPane reportEditor;
    private JScrollPane tab1ScrollPane;
    private JScrollPane tab2ScrollPane;
    private JTabbedPane tabbedPane;

    public ProcessorIssuesReportPanel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProcessorIssuesReportPanel.this.initComponents();
                    ProcessorIssuesReportPanel.this.initIcons();
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fillingThreads = new ThreadGroup("Report Panel Issues");
        this.reportEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu contextMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem();
                    menuItem.setText(NbBundle.getMessage(ProcessorIssuesReportPanel.class, (String)"ReportPanel.reportCopy.text"));
                    menuItem.setToolTipText(NbBundle.getMessage(ProcessorIssuesReportPanel.class, (String)"ReportPanel.reportCopy.description"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clpbrd.setContents(new StringSelection(ProcessorIssuesReportPanel.this.reportEditor.getText()), null);
                        }
                    });
                    contextMenu.add(menuItem);
                    contextMenu.show(ProcessorIssuesReportPanel.this.reportEditor, e.getX(), e.getY());
                }
            }
        });
    }

    public void initIcons() {
        this.infoIcon = ImageUtilities.loadImageIcon((String)"DesktopImport/info.svg", (boolean)false);
        this.warningIcon = ImageUtilities.loadImageIcon((String)"DesktopImport/warning.svg", (boolean)false);
        this.severeIcon = ImageUtilities.loadImageIcon((String)"DesktopImport/severe.svg", (boolean)false);
        this.criticalIcon = ImageUtilities.loadImageIcon((String)"DesktopImport/critical.svg", (boolean)false);
    }

    public void setData(Report report) {
        this.fillIssues(report);
        this.fillReport(report);
    }

    private void fillIssues(Report report) {
        final ArrayList<Issue> issues = new ArrayList<Issue>();
        Iterator itr = report.getIssues(5000);
        while (itr.hasNext()) {
            issues.add((Issue)itr.next());
        }
        if (issues.isEmpty()) {
            JLabel label = new JLabel(NbBundle.getMessage(this.getClass(), (String)"ReportPanel.noIssues"));
            label.setHorizontalAlignment(0);
            this.tab1ScrollPane.setViewportView(label);
        } else {
            final BusyUtils.BusyLabel busyLabel = BusyUtils.createCenteredBusyLabel((JScrollPane)this.tab1ScrollPane, (String)"Retrieving issues...", (JComponent)this.issuesOutline);
            Thread thread = new Thread(this.fillingThreads, new Runnable(){

                @Override
                public void run() {
                    busyLabel.setBusy(true);
                    IssueTreeModel treeMdl = new IssueTreeModel(issues);
                    final OutlineModel mdl = DefaultOutlineModel.createOutlineModel((TreeModel)treeMdl, (RowModel)new IssueRowModel(), (boolean)true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProcessorIssuesReportPanel.this.issuesOutline.setRootVisible(false);
                            ProcessorIssuesReportPanel.this.issuesOutline.setRenderDataProvider((RenderDataProvider)new IssueRenderer());
                            ProcessorIssuesReportPanel.this.issuesOutline.setModel((TableModel)mdl);
                            busyLabel.setBusy(false);
                        }
                    });
                }
            }, "Report Panel Issues Outline");
            if (NbPreferences.forModule(ProcessorIssuesReportPanel.class).getBoolean(SHOW_ISSUES, true)) {
                thread.start();
            }
        }
    }

    private void fillReport(final Report report) {
        Thread thread = new Thread(this.fillingThreads, new Runnable(){

            @Override
            public void run() {
                final String str = report.getText(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProcessorIssuesReportPanel.this.reportEditor.setText(str);
                    }
                });
            }
        }, "Report Panel Issues Report");
        if (NbPreferences.forModule(ProcessorIssuesReportPanel.class).getBoolean(SHOW_REPORT, true)) {
            thread.start();
        }
    }

    public void destroy() {
        this.fillingThreads.interrupt();
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tab1ScrollPane = new JScrollPane();
        this.issuesOutline = new Outline();
        this.tab2ScrollPane = new JScrollPane();
        this.reportEditor = new JEditorPane();
        this.tab1ScrollPane.setViewportView((Component)this.issuesOutline);
        this.tabbedPane.addTab(NbBundle.getMessage(ProcessorIssuesReportPanel.class, (String)"ProcessorIssuesReportPanel.tab1ScrollPane.TabConstraints.tabTitle"), this.tab1ScrollPane);
        this.reportEditor.setEditable(false);
        this.reportEditor.setFocusable(false);
        this.tab2ScrollPane.setViewportView(this.reportEditor);
        this.tabbedPane.addTab(NbBundle.getMessage(ProcessorIssuesReportPanel.class, (String)"ProcessorIssuesReportPanel.tab2ScrollPane.TabConstraints.tabTitle"), this.tab2ScrollPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 557, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, 270, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class IssueRenderer
    implements RenderDataProvider {
        private IssueRenderer() {
        }

        public String getDisplayName(Object o) {
            Issue issue = (Issue)o;
            return issue.getMessage();
        }

        public boolean isHtmlDisplayName(Object o) {
            return false;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            return null;
        }

        public String getTooltipText(Object o) {
            return "";
        }

        public Icon getIcon(Object o) {
            Issue issue = (Issue)o;
            switch (issue.getLevel()) {
                case INFO: {
                    return ProcessorIssuesReportPanel.this.infoIcon;
                }
                case WARNING: {
                    return ProcessorIssuesReportPanel.this.warningIcon;
                }
                case SEVERE: {
                    return ProcessorIssuesReportPanel.this.severeIcon;
                }
                case CRITICAL: {
                    return ProcessorIssuesReportPanel.this.criticalIcon;
                }
            }
            return null;
        }
    }

    private class IssueRowModel
    implements RowModel {
        private IssueRowModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueFor(Object node, int column) {
            if (node instanceof Issue) {
                Issue issue = (Issue)node;
                return issue.getLevel().toString();
            }
            return "";
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueFor(Object node, int column, Object value) {
        }

        public String getColumnName(int column) {
            return NbBundle.getMessage(ProcessorIssuesReportPanel.class, (String)"ReportPanel.issueTable.issues");
        }
    }

    private class IssueTreeModel
    implements TreeModel {
        private final List<Issue> issues;

        public IssueTreeModel(List<Issue> issues) {
            this.issues = issues;
        }

        @Override
        public Object getRoot() {
            return "root";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.issues.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.issues.size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof Issue;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.issues.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

