/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Dialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.desktop.importer.ProcessorIssuesReportPanel;
import org.gephi.desktop.importer.ReportPanel;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.api.ImportController;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.DatabaseImporter;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterUI;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.gephi.io.importer.spi.WizardImporter;
import org.gephi.io.processor.spi.Processor;
import org.gephi.io.processor.spi.ProcessorUI;
import org.gephi.lib.validation.DialogDescriptorWithValidation;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.utils.CharsetToolkit;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.io.ReaderInputStream;

public class DesktopImportControllerUI
implements ImportControllerUI {
    private final LongTaskExecutor executor;
    private final LongTaskErrorHandler defaultErrorHandler;
    private final ImportController controller = (ImportController)Lookup.getDefault().lookup(ImportController.class);

    public DesktopImportControllerUI() {
        this.defaultErrorHandler = new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    return;
                }
                Exceptions.printStackTrace((Throwable)t);
            }
        };
        this.executor = new LongTaskExecutor(true, "Importer", 10);
    }

    public void importFile(FileObject fileObject) {
        this.importFiles(new FileObject[]{fileObject});
    }

    public void importFiles(FileObject[] fileObjects) {
        MostRecentFiles mostRecentFiles = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        fileObjects = Arrays.copyOf(fileObjects, fileObjects.length);
        for (int i = 0; i < fileObjects.length; ++i) {
            fileObjects[i] = ImportUtils.getArchivedFile((FileObject)fileObjects[i]);
            if (!FileUtil.isArchiveArtifact((FileObject)fileObjects[i])) continue;
            try {
                File tempDir = TempDirUtils.createTempDirectory();
                fileObjects[i] = FileUtil.copyFile((FileObject)fileObjects[i], (FileObject)FileUtil.toFileObject((File)tempDir), (String)fileObjects[i].getName());
                continue;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Reader[] readers = new Reader[fileObjects.length];
        FileImporter[] importers = new FileImporter[fileObjects.length];
        try {
            for (int i = 0; i < fileObjects.length; ++i) {
                FileObject fileObject = fileObjects[i];
                importers[i] = this.controller.getFileImporter(fileObject);
                if (importers[i] == null) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return;
                }
                readers[i] = ImportUtils.getTextReader((FileObject)fileObject);
                mostRecentFiles.addFile(fileObject.getPath());
            }
            this.importFiles(readers, importers, fileObjects, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void importStream(InputStream stream, String importerName) {
        this.importStream(stream, null, importerName);
    }

    public void importStream(InputStream stream, String streamName, String importerName) {
        FileImporter importer = this.controller.getFileImporter(importerName);
        if (importer == null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        try {
            LineNumberReader reader = ImportUtils.getTextReader((InputStream)stream);
            this.importFile((Reader)reader, streamName, importer);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void importFile(Reader reader, String importerName) {
        this.importFile(reader, null, importerName);
    }

    public void importFile(Reader reader, String fileName, String importerName) {
        FileImporter importer = this.controller.getFileImporter(importerName);
        if (importer == null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        this.importFile(reader, fileName, importer);
    }

    private void importFile(Reader reader, String fileName, FileImporter importer) {
        this.importFiles(new Reader[]{reader}, new FileImporter[]{importer}, new String[]{fileName});
    }

    private void importFiles(Reader[] readers, FileImporter[] importers, String[] names) {
        this.importFiles(readers, importers, null, names);
    }

    private void importFiles(Reader[] readers, FileImporter[] importers, FileObject[] fileObjects, String[] names) {
        try {
            ImporterUI ui;
            File[] files = new File[readers.length];
            HashMap<ImporterUI, ArrayList<FileImporter>> importerUIs = new HashMap<ImporterUI, ArrayList<FileImporter>>();
            for (int i = 0; i < importers.length; ++i) {
                FileImporter importer = importers[i];
                ui = this.controller.getUI((Importer)importer);
                if (ui != null) {
                    ArrayList<FileImporter> l = (ArrayList<FileImporter>)importerUIs.get(ui);
                    if (l == null) {
                        l = new ArrayList<FileImporter>();
                        importerUIs.put(ui, l);
                    }
                    l.add(importer);
                }
                if (!(importer instanceof FileImporter.FileAware)) continue;
                try (Reader reader = readers[i];){
                    File file = null;
                    if (fileObjects != null) {
                        file = FileUtil.toFile((FileObject)fileObjects[i]);
                    }
                    if (file == null) {
                        String fileName = "tmp_file1";
                        String charset = "UTF-8";
                        if (fileObjects != null && fileObjects[i] != null) {
                            fileName = fileObjects[i].getNameExt();
                            CharsetToolkit charsetToolkit = new CharsetToolkit(fileObjects[i].getInputStream());
                            charset = charsetToolkit.getCharset().name();
                        }
                        file = TempDirUtils.createTempDir().createFile(fileName);
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            FileUtil.copy((InputStream)new ReaderInputStream(reader, charset), (OutputStream)fos);
                        }
                    }
                    files[i] = file;
                    ((FileImporter.FileAware)importer).setFile(file);
                    continue;
                }
            }
            for (Map.Entry entry : importerUIs.entrySet()) {
                boolean finishedOk;
                ui = (ImporterUI)entry.getKey();
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.file.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                FileImporter[] fi = ((List)entry.getValue()).toArray((FileImporter[])Array.newInstance(((FileImporter)((List)entry.getValue()).get(0)).getClass(), 0));
                ui.setup((Importer[])fi);
                if (panel != null) {
                    DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)panel, (String)title);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (!result.equals(NotifyDescriptor.OK_OPTION)) {
                        ui.unsetup(false);
                        return;
                    }
                }
                if (ui instanceof ImporterUI.WithWizard && !(finishedOk = this.showWizard(ui, ((ImporterUI.WithWizard)ui).getWizardDescriptor()))) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
            }
            ImportErrorHandler errorHandler = new ImportErrorHandler();
            ArrayList<Container> results = new ArrayList<Container>();
            for (int i = 0; i < importers.length; ++i) {
                this.doImport(results, readers[i], names != null ? names[0] : null, fileObjects != null ? fileObjects[i] : null, files[i], importers[i], errorHandler);
            }
            String taskName = null;
            taskName = importers.length == 1 ? NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.finishingImport", (Object)(fileObjects != null ? fileObjects[0].getNameExt() : (names != null ? names[0] : null))) : NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.multiImport.finishingImport", (Object)importers.length);
            FinishImport finishImport = new FinishImport(results, errorHandler);
            this.executor.execute((LongTask)finishImport, (Runnable)finishImport, taskName, this.defaultErrorHandler);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void doImport(List<Container> results, Reader reader, String containerName, FileObject fileObject, File file, FileImporter importer, ImportErrorHandler errorHandler) {
        LongTask task = null;
        if (importer instanceof LongTask) {
            task = (LongTask)importer;
        }
        if (file == null && reader == null) {
            throw new NullPointerException("Null file and reader!");
        }
        if (importer == null) {
            throw new NullPointerException("Null importer!");
        }
        String containerSource = fileObject != null ? fileObject.getNameExt() : (containerName != null ? containerName : NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.streamSource", (Object)importer.getClass().getSimpleName()));
        String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
        this.executor.execute(task, () -> {
            try {
                Container container = importer instanceof FileImporter.FileAware && file != null ? this.controller.importFile(file, importer) : this.controller.importFile(reader, importer);
                if (container != null) {
                    container.setSource(containerSource);
                    results.add(container);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }, taskName, errorHandler.createHandler(containerSource));
    }

    private boolean showWizard(ImporterUI importer, WizardDescriptor wizardDescriptor) {
        if (wizardDescriptor == null) {
            return true;
        }
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setTitle(importer.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        return wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    public void importDatabase(DatabaseImporter importer) {
        this.importDatabase(null, importer);
    }

    public void importDatabase(Database database, final DatabaseImporter importer) {
        try {
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.error_no_matching_db_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.database.ui.dialog.title");
                JPanel panel = ui.getPanel();
                ui.setup((Importer[])new DatabaseImporter[]{importer});
                DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)panel, (String)title);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (result.equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
                if (database == null) {
                    database = importer.getDatabase();
                }
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            final String containerSource = database != null ? database.getName() : (ui != null ? ui.getDisplayName() : importer.getClass().getSimpleName());
            final Database db = database;
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importDatabase(db, importer);
                        if (container != null) {
                            container.setSource(containerSource);
                            new FinishImport(Collections.singletonList(container), null).run();
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.defaultErrorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.SEVERE, "", ex);
        }
    }

    public void importWizard(final WizardImporter importer) {
        try {
            ImporterWizardUI wizardUI;
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.error_no_matching_db_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            Object containerSource = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.wizardSource", (Object)"");
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.wizard.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                ui.setup((Importer[])new WizardImporter[]{importer});
                DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)panel, (String)title);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (result.equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
                containerSource = ui.getDisplayName();
            }
            if ((wizardUI = this.controller.getWizardUI((Importer)importer)) != null) {
                containerSource = wizardUI.getCategory() + ":" + wizardUI.getDisplayName();
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            Object source = containerSource;
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){
                final /* synthetic */ String val$source;
                {
                    this.val$source = string;
                }

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importWizard(importer);
                        if (container != null) {
                            container.setSource(this.val$source);
                            new FinishImport(Collections.singletonList(container), null).run();
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.defaultErrorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    private void showProcessorIssues(Report report) {
        ProcessorIssuesReportPanel issuesReport = new ProcessorIssuesReportPanel();
        issuesReport.setData(report);
        DialogDescriptor dd = new DialogDescriptor((Object)issuesReport, NbBundle.getMessage(DesktopImportControllerUI.class, (String)"ProcessorIssuesReportPanel.title"));
        dd.setOptions(new Object[]{NbBundle.getMessage(DesktopImportControllerUI.class, (String)"ProcessorIssuesReportPanel.close")});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        issuesReport.destroy();
    }

    public ImportController getImportController() {
        return this.controller;
    }

    private ProcessorUI getProcessorUI(Processor processor) {
        for (ProcessorUI pui : Lookup.getDefault().lookupAll(ProcessorUI.class)) {
            if (!pui.isUIFoProcessor(processor)) continue;
            return pui;
        }
        return null;
    }

    private static class ImportErrorHandler {
        private final Report errorReport = new Report("temperrorhandler");
        private final AtomicInteger count = new AtomicInteger();

        private ImportErrorHandler() {
        }

        public LongTaskErrorHandler createHandler(final String source) {
            return new LongTaskErrorHandler(){

                public void fatalError(Throwable t) {
                    this.handleError(source, t);
                }
            };
        }

        public void handleError(String source, Throwable t) {
            if (t instanceof OutOfMemoryError) {
                return;
            }
            this.count.incrementAndGet();
            String msg = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.errorHandler.critical", (Object)source, (Object)t.getMessage());
            this.errorReport.logIssue(new Issue(msg, Issue.Level.SEVERE, t));
            Exceptions.printStackTrace((Throwable)t);
        }

        public int countErrors() {
            return this.count.get();
        }

        public Report closeAndGetReport() {
            this.errorReport.close();
            return this.errorReport;
        }
    }

    private class FinishImport
    implements LongTask,
    Runnable {
        private final List<Container> containers;
        private final ImportErrorHandler errorHandler;
        private ProgressTicket progressTicket;

        public FinishImport(List<Container> containers, ImportErrorHandler errorHandler) {
            this.containers = containers;
            this.errorHandler = errorHandler;
        }

        @Override
        public void run() {
            if (this.errorHandler != null) {
                Report errorReport = this.errorHandler.closeAndGetReport();
                if (this.errorHandler.countErrors() > 0) {
                    DesktopImportControllerUI.this.showProcessorIssues(errorReport);
                    return;
                }
            }
            Report finalReport = new Report();
            for (Container container : this.containers) {
                if (!container.verify()) continue;
                Report report = container.getReport();
                report.close();
                finalReport.append(report);
            }
            finalReport.close();
            if (!this.containers.isEmpty()) {
                ReportPanel reportPanel = new ReportPanel();
                reportPanel.setData(finalReport, this.containers.toArray(new Container[0]));
                DialogDescriptor dd = new DialogDescriptor((Object)reportPanel, NbBundle.getMessage(DesktopImportControllerUI.class, (String)"ReportPanel.title"));
                Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                reportPanel.destroy();
                finalReport.clean();
                for (Container c : this.containers) {
                    c.getReport().clean();
                }
                if (!response.equals(NotifyDescriptor.OK_OPTION)) {
                    return;
                }
                final Processor processor = reportPanel.getProcessor();
                processor.setProgressTicket(this.progressTicket);
                Workspace workspace = null;
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                if (pc.getCurrentProject() == null) {
                    Project project = pc.newProject();
                    workspace = project.getCurrentWorkspace();
                }
                final ProcessorUI pui = DesktopImportControllerUI.this.getProcessorUI(processor);
                final ValidResult validResult = new ValidResult();
                if (pui != null) {
                    try {
                        final JPanel panel = pui.getPanel();
                        if (panel != null) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.processor.ui.dialog.title");
                                    pui.setup(processor);
                                    DialogDescriptor dd2 = DialogDescriptorWithValidation.dialog((Object)panel, (String)title);
                                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd2);
                                    if (result.equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                                        validResult.setResult(false);
                                    } else {
                                        pui.unsetup();
                                        validResult.setResult(true);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (validResult.isResult()) {
                    DesktopImportControllerUI.this.controller.process(this.containers.toArray(new Container[0]), processor, workspace);
                    Report report = processor.getReport();
                    if (report != null && !report.isEmpty()) {
                        DesktopImportControllerUI.this.showProcessorIssues(report);
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.status.multiImportSuccess", (Object)this.containers.size()));
                }
            }
        }

        public boolean cancel() {
            return false;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
        }
    }

    private static class ValidResult {
        private boolean result = true;

        private ValidResult() {
        }

        public boolean isResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }
    }
}

