/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.values;

import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.ui.GeneralNumberListStatisticsReportUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.values.AttributeValueManipulator;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NumberListStatisticsReport
implements AttributeValueManipulator {
    private Number[] numbers;
    private Column column;

    public void setup(Element row, Column column) {
        this.column = column;
        if (AttributeUtils.isNumberType((Class)column.getTypeClass())) {
            this.numbers = ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).getRowNumbers(row, new Column[]{column});
        }
    }

    public void execute() {
    }

    public String getName() {
        return this.getMessage("NumberListStatisticsReport.name");
    }

    public String getDescription() {
        return this.getMessage("NumberListStatisticsReport.description");
    }

    public boolean canExecute() {
        return this.numbers != null && this.numbers.length > 1;
    }

    public ManipulatorUI getUI() {
        return new GeneralNumberListStatisticsReportUI(this.numbers, this.column.getTitle(), this.getName());
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/chart-up.svg", (boolean)false);
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(NumberListStatisticsReport.class, (String)resName);
    }
}

