/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsAndRowChooser;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;

public class GeneralChooseColumnsAndRowUI
extends JPanel
implements ManipulatorUI {
    private GeneralColumnsAndRowChooser columnsAndRowChooser;
    private ColumnCheckBox[] columnsCheckBoxes;
    private Element[] rows;
    private JLabel columnsDescriptionLabel;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;
    private JComboBox rowComboBox;
    private JLabel rowDescriptionLabel;

    public GeneralChooseColumnsAndRowUI(String rowDescription, String columnsDescription) {
        this.initComponents();
        this.rowDescriptionLabel.setText(rowDescription);
        this.columnsDescriptionLabel.setText(columnsDescription);
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.columnsAndRowChooser = (GeneralColumnsAndRowChooser)m;
        this.refreshColumns();
        this.refreshRows();
    }

    public void unSetup() {
        this.columnsAndRowChooser.setColumns(this.getChosenColumns());
        this.columnsAndRowChooser.setRow(this.rows[this.rowComboBox.getSelectedIndex()]);
    }

    public String getDisplayName() {
        return this.columnsAndRowChooser.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    public Column[] getChosenColumns() {
        ArrayList<Column> columnsToClearDataList = new ArrayList<Column>();
        for (ColumnCheckBox c : this.columnsCheckBoxes) {
            if (!c.isSelected()) continue;
            columnsToClearDataList.add(c.getColumn());
        }
        return columnsToClearDataList.toArray(new Column[0]);
    }

    private void refreshColumns() {
        Column[] columns = this.columnsAndRowChooser.getColumns();
        this.columnsCheckBoxes = new ColumnCheckBox[columns.length];
        this.contentPanel.removeAll();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        for (int i = 0; i < columns.length; ++i) {
            this.columnsCheckBoxes[i] = new ColumnCheckBox(columns[i], true);
            this.contentPanel.add((Component)this.columnsCheckBoxes[i].getCheckBox(), "wrap");
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void refreshRows() {
        this.rows = this.columnsAndRowChooser.getRows();
        Element sourceRow = this.columnsAndRowChooser.getRow();
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] instanceof Node) {
                Node node = (Node)this.rows[i];
                this.rowComboBox.addItem(String.valueOf(node.getId()) + " - " + node.getLabel());
            } else {
                Edge edge = (Edge)this.rows[i];
                this.rowComboBox.addItem(String.valueOf(edge.getId()) + " - " + edge.getLabel());
            }
            if (this.rows[i] != sourceRow) continue;
            this.rowComboBox.setSelectedIndex(i);
        }
    }

    private void initComponents() {
        this.contentScrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.columnsDescriptionLabel = new JLabel();
        this.rowDescriptionLabel = new JLabel();
        this.rowComboBox = new JComboBox();
        this.contentPanel.setLayout(new GridLayout(1, 0));
        this.contentScrollPane.setViewportView(this.contentPanel);
        this.columnsDescriptionLabel.setText(null);
        this.rowDescriptionLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.columnsDescriptionLabel, -1, 301, Short.MAX_VALUE).addComponent(this.contentScrollPane, -1, 301, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.rowDescriptionLabel, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rowComboBox, 0, 142, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rowDescriptionLabel).addComponent(this.rowComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsDescriptionLabel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentScrollPane, -1, 194, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ColumnCheckBox {
        private final JCheckBox checkBox;
        private final Column column;

        public ColumnCheckBox(Column column, boolean selected) {
            this.checkBox = new JCheckBox(column.getTitle(), selected);
            this.column = column;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public Column getColumn() {
            return this.column;
        }
    }
}

