/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.nodes.ui.MergeNodesUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergeNodes
extends BasicNodesManipulator {
    public static final String DELETE_MERGED_NODES_SAVED_PREFERENCES = "MergeNodes_DeleteMergedNodes";
    private Node[] nodes;
    private Node selectedNode;
    private Column[] columns;
    private AttributeRowsMergeStrategy[] mergeStrategies;
    private boolean deleteMergedNodes;

    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
        this.selectedNode = clickedNode != null ? clickedNode : nodes[0];
        Table nodeTable = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
        ArrayList<Column> columnsList = new ArrayList<Column>();
        for (Column column : nodeTable) {
            if (column.isReadOnly()) continue;
            columnsList.add(column);
        }
        this.columns = columnsList.toArray(new Column[0]);
        this.mergeStrategies = new AttributeRowsMergeStrategy[this.columns.length];
        this.deleteMergedNodes = NbPreferences.forModule(MergeNodes.class).getBoolean(DELETE_MERGED_NODES_SAVED_PREFERENCES, true);
    }

    public void execute() {
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        Node newNode = gec.mergeNodes(graph, this.nodes, this.selectedNode, this.columns, this.mergeStrategies, this.deleteMergedNodes);
        ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).setNodeTableSelection(new Node[]{newNode});
        NbPreferences.forModule(MergeNodes.class).putBoolean(DELETE_MERGED_NODES_SAVED_PREFERENCES, this.deleteMergedNodes);
    }

    public String getName() {
        return NbBundle.getMessage(MergeNodes.class, (String)"MergeNodes.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(MergeNodes.class, (String)"MergeNodes.description");
    }

    public boolean canExecute() {
        return this.nodes.length > 1;
    }

    public ManipulatorUI getUI() {
        return new MergeNodesUI();
    }

    public int getType() {
        return 500;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/merge.svg", (boolean)false);
    }

    public boolean isDeleteMergedNodes() {
        return this.deleteMergedNodes;
    }

    public void setDeleteMergedNodes(boolean deleteMergedNodes) {
        this.deleteMergedNodes = deleteMergedNodes;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public AttributeRowsMergeStrategy[] getMergeStrategies() {
        return this.mergeStrategies;
    }

    public void setMergeStrategies(AttributeRowsMergeStrategy[] mergeStrategies) {
        this.mergeStrategies = mergeStrategies;
    }
}

