/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.nodes.ui.CopyNodesUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyNodes
extends BasicNodesManipulator {
    private Node[] nodes;
    private int copies = 1;

    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
    }

    public void execute() {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        for (int i = 0; i < this.copies; ++i) {
            gec.duplicateNodes(this.nodes);
        }
    }

    public String getName() {
        if (this.nodes.length > 1) {
            return NbBundle.getMessage(CopyNodes.class, (String)"CopyNodes.name.multiple");
        }
        return NbBundle.getMessage(CopyNodes.class, (String)"CopyNodes.name.single");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new CopyNodesUI();
    }

    public int getType() {
        return 500;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/duplicate.svg", (boolean)false);
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        this.copies = copies;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public void setNodes(Node[] nodes) {
        this.nodes = nodes;
    }
}

