/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsAndRowChooser;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.ui.GeneralChooseColumnsAndRowUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyNodeDataToOtherNodes
extends BasicNodesManipulator
implements GeneralColumnsAndRowChooser {
    private Node clickedNode;
    private Node[] nodes;
    private Column[] columnsToCopyData;

    public void setup(Node[] nodes, Node clickedNode) {
        this.clickedNode = clickedNode;
        this.nodes = nodes;
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ArrayList<Column> columnsToCopyDataList = new ArrayList<Column>();
        for (Column column : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable()) {
            if (!ac.canChangeColumnData(column)) continue;
            columnsToCopyDataList.add(column);
        }
        this.columnsToCopyData = columnsToCopyDataList.toArray(new Column[0]);
    }

    public void execute() {
        if (this.columnsToCopyData.length >= 0) {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            ac.copyNodeDataToOtherNodes(this.clickedNode, this.nodes, this.columnsToCopyData);
            ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).refreshCurrentTable();
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(CopyNodeDataToOtherNodes.class, (String)"CopyNodeDataToOtherNodes.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyNodeDataToOtherNodes.class, (String)"CopyNodeDataToOtherNodes.description");
    }

    public boolean canExecute() {
        return this.nodes.length > 1;
    }

    public ManipulatorUI getUI() {
        return new GeneralChooseColumnsAndRowUI(NbBundle.getMessage(CopyNodeDataToOtherNodes.class, (String)"CopyNodeDataToOtherNodes.ui.rowDescription"), NbBundle.getMessage(CopyNodeDataToOtherNodes.class, (String)"CopyNodeDataToOtherNodes.ui.columnsDescription"));
    }

    public int getType() {
        return 200;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/broom--arrow.svg", (boolean)false);
    }

    @Override
    public Column[] getColumns() {
        return this.columnsToCopyData;
    }

    @Override
    public void setColumns(Column[] columnsToClearData) {
        this.columnsToCopyData = columnsToClearData;
    }

    @Override
    public Element[] getRows() {
        return this.nodes;
    }

    @Override
    public Element getRow() {
        return this.clickedNode;
    }

    @Override
    public void setRow(Element row) {
        this.clickedNode = (Node)row;
    }
}

