/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.general.ui.ClearEdgesUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.PluginGeneralActionsManipulator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ClearEdges
implements PluginGeneralActionsManipulator {
    public static final String DELETE_DIRECTED_SAVED_PREFERENCES = "ClearEdges_deleteDirected";
    public static final String DELETE_UNDIRECTED_SAVED_PREFERENCES = "ClearEdges_deleteUndirected";
    private boolean deleteDirected = NbPreferences.forModule(ClearEdges.class).getBoolean("ClearEdges_deleteDirected", true);
    private boolean deleteUndirected = NbPreferences.forModule(ClearEdges.class).getBoolean("ClearEdges_deleteUndirected", true);

    public void execute() {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : graph.getEdges().toArray()) {
            if (edge.isDirected()) {
                if (!this.deleteDirected) continue;
                edges.add(edge);
                continue;
            }
            if (!this.deleteUndirected) continue;
            edges.add(edge);
        }
        gec.deleteEdges(edges.toArray(new Edge[0]));
    }

    public String getName() {
        return NbBundle.getMessage(ClearEdges.class, (String)"ClearEdges.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getEdgesCount() > 0;
    }

    public ManipulatorUI getUI() {
        return new ClearEdgesUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 300;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/eraser--minus.svg", (boolean)false);
    }

    public boolean isDeleteDirected() {
        return this.deleteDirected;
    }

    public void setDeleteDirected(boolean deleteDirected) {
        this.deleteDirected = deleteDirected;
    }

    public boolean isDeleteUndirected() {
        return this.deleteUndirected;
    }

    public void setDeleteUndirected(boolean deleteUndirected) {
        this.deleteUndirected = deleteUndirected;
    }
}

