/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.edges;

import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.edges.BasicEdgesManipulator;
import org.gephi.datalab.plugin.manipulators.edges.ui.DeleteEdgesWithNodesUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Edge;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DeleteEdgesWithNodes
extends BasicEdgesManipulator {
    private Edge[] edges;
    private boolean deleteSource;
    private boolean deleteTarget;

    public void setup(Edge[] edges, Edge clickedEdge) {
        this.edges = edges;
    }

    public void execute() {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        gec.deleteEdgesWithNodes(this.edges, this.deleteSource, this.deleteTarget);
    }

    public String getName() {
        if (this.edges.length > 1) {
            return NbBundle.getMessage(DeleteEdgesWithNodes.class, (String)"DeleteEdgesWithNodes.name.multiple");
        }
        return NbBundle.getMessage(DeleteEdgesWithNodes.class, (String)"DeleteEdgesWithNodes.name.single");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new DeleteEdgesWithNodesUI();
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 400;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/cross.svg", (boolean)false);
    }

    public void setDeleteSource(boolean deleteSource) {
        this.deleteSource = deleteSource;
    }

    public void setDeleteTarget(boolean deleteTarget) {
        this.deleteTarget = deleteTarget;
    }
}

