/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge;

import java.text.SimpleDateFormat;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.datalab.plugin.manipulators.columns.merge.ui.CreateTimeIntervalUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CreateTimeInterval
implements AttributeColumnsMergeStrategy {
    private Table table;
    private Column[] columns;
    private Column startColumn;
    private Column endColumn;
    private boolean parseNumbers = true;
    private double startNumber;
    private double endNumber;
    private SimpleDateFormat dateFormat;
    private String startDate;
    private String endDate;

    public void setup(Table table, Column[] columns) {
        this.table = table;
        this.columns = columns;
    }

    public void execute() {
        AttributeColumnsMergeStrategiesController ac = (AttributeColumnsMergeStrategiesController)Lookup.getDefault().lookup(AttributeColumnsMergeStrategiesController.class);
        if (this.parseNumbers) {
            ac.mergeNumericColumnsToTimeInterval(this.table, this.startColumn, this.endColumn, this.startNumber, this.endNumber);
        } else {
            ac.mergeDateColumnsToTimeInterval(this.table, this.startColumn, this.endColumn, this.dateFormat, this.startDate, this.endDate);
        }
    }

    public String getName() {
        return NbBundle.getMessage(CreateTimeInterval.class, (String)"CreateTimeInterval.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateTimeInterval.class, (String)"CreateTimeInterval.description");
    }

    public boolean canExecute() {
        TimeRepresentation timeRepresentation = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getConfiguration().getTimeRepresentation();
        if (timeRepresentation != TimeRepresentation.INTERVAL) {
            return false;
        }
        return this.columns.length == 1 || this.columns.length == 2;
    }

    public ManipulatorUI getUI() {
        return new CreateTimeIntervalUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/clock-select.svg", (boolean)false);
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Column getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(Column endColumn) {
        this.endColumn = endColumn;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public double getEndNumber() {
        return this.endNumber;
    }

    public void setEndNumber(double endNumber) {
        this.endNumber = endNumber;
    }

    public boolean isParseNumbers() {
        return this.parseNumbers;
    }

    public void setParseNumbers(boolean parseNumbers) {
        this.parseNumbers = parseNumbers;
    }

    public Column getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(Column startColumn) {
        this.startColumn = startColumn;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public double getStartNumber() {
        return this.startNumber;
    }

    public void setStartNumber(double startNumber) {
        this.startNumber = startNumber;
    }
}

