/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.type.ByteArrayTag;
import net.md_5.bungee.nbt.type.ByteTag;
import net.md_5.bungee.nbt.type.CompoundTag;
import net.md_5.bungee.nbt.type.DoubleTag;
import net.md_5.bungee.nbt.type.EndTag;
import net.md_5.bungee.nbt.type.FloatTag;
import net.md_5.bungee.nbt.type.IntArrayTag;
import net.md_5.bungee.nbt.type.IntTag;
import net.md_5.bungee.nbt.type.ListTag;
import net.md_5.bungee.nbt.type.LongArrayTag;
import net.md_5.bungee.nbt.type.LongTag;
import net.md_5.bungee.nbt.type.ShortTag;
import net.md_5.bungee.nbt.type.StringTag;

public final class TagUtil {
    private static byte nbtTypeOfJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return 1;
                }
                if (number instanceof Short) {
                    return 2;
                }
                if (number instanceof Integer) {
                    return 3;
                }
                if (number instanceof Long) {
                    return 4;
                }
                if (number instanceof Float) {
                    return 5;
                }
                if (number instanceof Double) {
                    return 6;
                }
            } else {
                if (jsonPrimitive.isString()) {
                    return 8;
                }
                if (jsonPrimitive.isBoolean()) {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Unknown JSON primitive: " + jsonPrimitive);
        }
        if (json instanceof JsonObject) {
            return 10;
        }
        if (json instanceof JsonArray) {
            JsonArray array = json.getAsJsonArray();
            Byte listType = null;
            for (JsonElement jsonEl : array) {
                byte type = TagUtil.nbtTypeOfJson(jsonEl);
                if (listType == null) {
                    listType = type;
                    continue;
                }
                if (listType == type) continue;
                listType = 10;
                break;
            }
            if (listType == null) {
                return 9;
            }
            switch (listType) {
                case 1: {
                    return 7;
                }
                case 3: {
                    return 11;
                }
                case 4: {
                    return 12;
                }
            }
            return 9;
        }
        if (json instanceof JsonNull) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown JSON element: " + json);
    }

    public static TypedTag fromJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return new ByteTag(((Byte)number).byteValue());
                }
                if (number instanceof Short) {
                    return new ShortTag(((Short)number).shortValue());
                }
                if (number instanceof Integer) {
                    return new IntTag(((Integer)number).intValue());
                }
                if (number instanceof Long) {
                    return new LongTag(((Long)number).longValue());
                }
                if (number instanceof Float) {
                    return new FloatTag(((Float)number).floatValue());
                }
                if (number instanceof Double) {
                    return new DoubleTag(((Double)number).doubleValue());
                }
            } else {
                if (jsonPrimitive.isString()) {
                    return new StringTag(jsonPrimitive.getAsString());
                }
                if (jsonPrimitive.isBoolean()) {
                    return new ByteTag((byte)(jsonPrimitive.getAsBoolean() ? 1 : 0));
                }
            }
            throw new IllegalArgumentException("Unknown JSON primitive: " + jsonPrimitive);
        }
        if (json instanceof JsonObject) {
            CompoundTag compoundTag = new CompoundTag(new LinkedHashMap());
            for (Map.Entry property : ((JsonObject)json).entrySet()) {
                compoundTag.getValue().put((String)property.getKey(), TagUtil.fromJson((JsonElement)property.getValue()));
            }
            return compoundTag;
        }
        if (json instanceof JsonArray) {
            ByteArrayTag listTag;
            List jsonArray = ((JsonArray)json).asList();
            Byte listType = null;
            for (JsonElement jsonEl : jsonArray) {
                byte type = TagUtil.nbtTypeOfJson(jsonEl);
                if (listType == null) {
                    listType = type;
                    continue;
                }
                if (listType == type) continue;
                listType = 10;
                break;
            }
            if (listType == null || listType == 0) {
                if (!jsonArray.isEmpty()) {
                    throw new IllegalArgumentException("Invalid end tag in json array: " + json);
                }
                return new ListTag(Collections.emptyList(), 0);
            }
            switch (listType) {
                case 1: {
                    byte[] bytes = new byte[jsonArray.size()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (Byte)((JsonElement)jsonArray.get(i)).getAsNumber();
                    }
                    listTag = new ByteArrayTag(bytes);
                    break;
                }
                case 3: {
                    int[] ints = new int[jsonArray.size()];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = (Integer)((JsonElement)jsonArray.get(i)).getAsNumber();
                    }
                    listTag = new IntArrayTag(ints);
                    break;
                }
                case 4: {
                    long[] longs = new long[jsonArray.size()];
                    for (int i = 0; i < longs.length; ++i) {
                        longs[i] = (Long)((JsonElement)jsonArray.get(i)).getAsNumber();
                    }
                    listTag = new LongArrayTag(longs);
                    break;
                }
                default: {
                    ArrayList<TypedTag> tagItems = new ArrayList<TypedTag>(jsonArray.size());
                    for (JsonElement jsonEl : jsonArray) {
                        TypedTag subTag = TagUtil.fromJson(jsonEl);
                        if (listType == 10 && !(subTag instanceof CompoundTag)) {
                            CompoundTag wrapper = new CompoundTag(new LinkedHashMap());
                            wrapper.getValue().put("", subTag);
                            subTag = wrapper;
                        }
                        tagItems.add(subTag);
                    }
                    listTag = new ListTag(tagItems, listType.byteValue());
                }
            }
            return listTag;
        }
        if (json instanceof JsonNull) {
            return EndTag.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown JSON element: " + json);
    }

    public static JsonElement toJson(TypedTag tag) {
        switch (tag.getId()) {
            case 1: {
                return new JsonPrimitive((Number)((ByteTag)tag).getValue());
            }
            case 2: {
                return new JsonPrimitive((Number)((ShortTag)tag).getValue());
            }
            case 3: {
                return new JsonPrimitive((Number)((IntTag)tag).getValue());
            }
            case 4: {
                return new JsonPrimitive((Number)((LongTag)tag).getValue());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((FloatTag)tag).getValue()));
            }
            case 6: {
                return new JsonPrimitive((Number)((DoubleTag)tag).getValue());
            }
            case 7: {
                byte[] byteArray = ((ByteArrayTag)tag).getValue();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add((JsonElement)new JsonPrimitive((Number)b));
                }
                return jsonByteArray;
            }
            case 8: {
                return new JsonPrimitive(((StringTag)tag).getValue());
            }
            case 9: {
                List items = ((ListTag)tag).getValue();
                JsonArray jsonList = new JsonArray(items.size());
                for (TypedTag subTag : items) {
                    TypedTag first;
                    CompoundTag compound;
                    if (subTag instanceof CompoundTag && (compound = (CompoundTag)subTag).getValue().size() == 1 && (first = (TypedTag)compound.getValue().get("")) != null) {
                        jsonList.add(TagUtil.toJson(first));
                        continue;
                    }
                    jsonList.add(TagUtil.toJson(subTag));
                }
                return jsonList;
            }
            case 10: {
                JsonObject jsonObject = new JsonObject();
                CompoundTag compoundTag = (CompoundTag)tag;
                compoundTag.getValue().forEach((key, value) -> jsonObject.add(key, TagUtil.toJson(value)));
                return jsonObject;
            }
            case 11: {
                int[] intArray = ((IntArrayTag)tag).getValue();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add((JsonElement)new JsonPrimitive((Number)i));
                }
                return jsonIntArray;
            }
            case 12: {
                long[] longArray = ((LongArrayTag)tag).getValue();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add((JsonElement)new JsonPrimitive((Number)l));
                }
                return jsonLongArray;
            }
            case 0: {
                return JsonNull.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown NBT tag: " + tag);
    }

    @Generated
    private TagUtil() {
    }
}

