/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientSettings
extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private int chatFlags;
    private boolean chatColours;
    private byte difficulty;
    private byte skinParts;
    private int mainHand;
    private boolean disableTextFiltering;
    private boolean allowServerListing;
    private ParticleStatus particleStatus;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.locale = ClientSettings.readString(buf, 16);
        this.viewDistance = buf.readByte();
        this.chatFlags = protocolVersion >= 107 ? DefinedPacket.readVarInt(buf) : (int)buf.readUnsignedByte();
        this.chatColours = buf.readBoolean();
        this.skinParts = buf.readByte();
        if (protocolVersion >= 107) {
            this.mainHand = DefinedPacket.readVarInt(buf);
        }
        if (protocolVersion >= 755) {
            this.disableTextFiltering = buf.readBoolean();
        }
        if (protocolVersion >= 757) {
            this.allowServerListing = buf.readBoolean();
        }
        if (protocolVersion >= 768) {
            this.particleStatus = ParticleStatus.values()[ClientSettings.readVarInt(buf)];
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientSettings.writeString(this.locale, buf);
        buf.writeByte((int)this.viewDistance);
        if (protocolVersion >= 107) {
            DefinedPacket.writeVarInt(this.chatFlags, buf);
        } else {
            buf.writeByte(this.chatFlags);
        }
        buf.writeBoolean(this.chatColours);
        buf.writeByte((int)this.skinParts);
        if (protocolVersion >= 107) {
            DefinedPacket.writeVarInt(this.mainHand, buf);
        }
        if (protocolVersion >= 755) {
            buf.writeBoolean(this.disableTextFiltering);
        }
        if (protocolVersion >= 757) {
            buf.writeBoolean(this.allowServerListing);
        }
        if (protocolVersion >= 768) {
            ClientSettings.writeVarInt(this.particleStatus.ordinal(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public byte getViewDistance() {
        return this.viewDistance;
    }

    @Generated
    public int getChatFlags() {
        return this.chatFlags;
    }

    @Generated
    public boolean isChatColours() {
        return this.chatColours;
    }

    @Generated
    public byte getDifficulty() {
        return this.difficulty;
    }

    @Generated
    public byte getSkinParts() {
        return this.skinParts;
    }

    @Generated
    public int getMainHand() {
        return this.mainHand;
    }

    @Generated
    public boolean isDisableTextFiltering() {
        return this.disableTextFiltering;
    }

    @Generated
    public boolean isAllowServerListing() {
        return this.allowServerListing;
    }

    @Generated
    public ParticleStatus getParticleStatus() {
        return this.particleStatus;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    @Generated
    public void setChatFlags(int chatFlags) {
        this.chatFlags = chatFlags;
    }

    @Generated
    public void setChatColours(boolean chatColours) {
        this.chatColours = chatColours;
    }

    @Generated
    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    @Generated
    public void setSkinParts(byte skinParts) {
        this.skinParts = skinParts;
    }

    @Generated
    public void setMainHand(int mainHand) {
        this.mainHand = mainHand;
    }

    @Generated
    public void setDisableTextFiltering(boolean disableTextFiltering) {
        this.disableTextFiltering = disableTextFiltering;
    }

    @Generated
    public void setAllowServerListing(boolean allowServerListing) {
        this.allowServerListing = allowServerListing;
    }

    @Generated
    public void setParticleStatus(ParticleStatus particleStatus) {
        this.particleStatus = particleStatus;
    }

    @Override
    @Generated
    public String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", chatColours=" + this.isChatColours() + ", difficulty=" + this.getDifficulty() + ", skinParts=" + this.getSkinParts() + ", mainHand=" + this.getMainHand() + ", disableTextFiltering=" + this.isDisableTextFiltering() + ", allowServerListing=" + this.isAllowServerListing() + ", particleStatus=" + (Object)((Object)this.getParticleStatus()) + ")";
    }

    @Generated
    public ClientSettings() {
    }

    @Generated
    public ClientSettings(String locale, byte viewDistance, int chatFlags, boolean chatColours, byte difficulty, byte skinParts, int mainHand, boolean disableTextFiltering, boolean allowServerListing, ParticleStatus particleStatus) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.chatColours = chatColours;
        this.difficulty = difficulty;
        this.skinParts = skinParts;
        this.mainHand = mainHand;
        this.disableTextFiltering = disableTextFiltering;
        this.allowServerListing = allowServerListing;
        this.particleStatus = particleStatus;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSettings)) {
            return false;
        }
        ClientSettings other = (ClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getChatFlags() != other.getChatFlags()) {
            return false;
        }
        if (this.isChatColours() != other.isChatColours()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getSkinParts() != other.getSkinParts()) {
            return false;
        }
        if (this.getMainHand() != other.getMainHand()) {
            return false;
        }
        if (this.isDisableTextFiltering() != other.isDisableTextFiltering()) {
            return false;
        }
        if (this.isAllowServerListing() != other.isAllowServerListing()) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        ParticleStatus this$particleStatus = this.getParticleStatus();
        ParticleStatus other$particleStatus = other.getParticleStatus();
        return !(this$particleStatus == null ? other$particleStatus != null : !((Object)((Object)this$particleStatus)).equals((Object)other$particleStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientSettings;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getChatFlags();
        result = result * 59 + (this.isChatColours() ? 79 : 97);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getSkinParts();
        result = result * 59 + this.getMainHand();
        result = result * 59 + (this.isDisableTextFiltering() ? 79 : 97);
        result = result * 59 + (this.isAllowServerListing() ? 79 : 97);
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        ParticleStatus $particleStatus = this.getParticleStatus();
        result = result * 59 + ($particleStatus == null ? 43 : ((Object)((Object)$particleStatus)).hashCode());
        return result;
    }

    public static enum ParticleStatus {
        ALL,
        DECREASED,
        MINIMAL;

    }
}

