/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.exception.NBTFormatException;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class ListTag
implements TypedTag {
    public static final int LIST_HEADER = 12;
    private List<TypedTag> value;
    private byte listType;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.push();
        limiter.countBytes(37L);
        this.listType = input.readByte();
        int length = input.readInt();
        if (length < 0) {
            throw new NBTFormatException("ListTag length cannot be negative");
        }
        if (this.listType == 0 && length > 0) {
            throw new NBTFormatException("Missing type in ListTag");
        }
        limiter.countBytes(length, 4L);
        ArrayList<TypedTag> tagList = new ArrayList<TypedTag>(length);
        for (int i = 0; i < length; ++i) {
            tagList.add(Tag.readById(this.listType, input, limiter));
        }
        limiter.pop();
        this.value = tagList;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.value, (Object)"list value cannot be null");
        if (this.listType == 0 && !this.value.isEmpty()) {
            throw new NBTFormatException("Missing type in ListTag");
        }
        output.writeByte(this.listType);
        output.writeInt(this.value.size());
        for (TypedTag tag : this.value) {
            if (tag.getId() != this.listType) {
                throw new NBTFormatException("ListTag type mismatch");
            }
            tag.write(output);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TypedTag get(int index) {
        return this.value.get(index);
    }

    public int size() {
        return this.value.size();
    }

    @Generated
    public List<TypedTag> getValue() {
        return this.value;
    }

    @Generated
    public byte getListType() {
        return this.listType;
    }

    @Generated
    public void setValue(List<TypedTag> value) {
        this.value = value;
    }

    @Generated
    public void setListType(byte listType) {
        this.listType = listType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTag)) {
            return false;
        }
        ListTag other = (ListTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListType() != other.getListType()) {
            return false;
        }
        List<TypedTag> this$value = this.getValue();
        List<TypedTag> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ListTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListType();
        List<TypedTag> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ListTag(value=" + this.getValue() + ", listType=" + this.getListType() + ")";
    }

    @Generated
    public ListTag() {
    }

    @Generated
    public ListTag(List<TypedTag> value, byte listType) {
        this.value = value;
        this.listType = listType;
    }
}

