/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.action;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.dialog.action.Action;

public class ActionButton {
    @NonNull
    private BaseComponent label;
    private BaseComponent tooltip;
    private Integer width;
    @NonNull
    private Action action;

    public ActionButton(@NonNull BaseComponent label, BaseComponent tooltip, Integer width, @NonNull Action action) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.label = label;
        this.tooltip = tooltip;
        this.setWidth(width);
        this.action = action;
    }

    public ActionButton(@NonNull BaseComponent label, @NonNull Action action) {
        this(label, null, null, action);
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
    }

    public void setWidth(Integer width) {
        Preconditions.checkArgument((width == null || width >= 1 && width <= 1024 ? 1 : 0) != 0, (Object)"width must be between 1 and 1024");
        this.width = width;
    }

    @NonNull
    @Generated
    public BaseComponent label() {
        return this.label;
    }

    @Generated
    public BaseComponent tooltip() {
        return this.tooltip;
    }

    @Generated
    public Integer width() {
        return this.width;
    }

    @NonNull
    @Generated
    public Action action() {
        return this.action;
    }

    @Generated
    public ActionButton label(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    @Generated
    public ActionButton tooltip(BaseComponent tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Generated
    public ActionButton width(Integer width) {
        this.width = width;
        return this;
    }

    @Generated
    public ActionButton action(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.action = action;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionButton)) {
            return false;
        }
        ActionButton other = (ActionButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        BaseComponent this$label = this.label();
        BaseComponent other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        BaseComponent this$tooltip = this.tooltip();
        BaseComponent other$tooltip = other.tooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        Action this$action = this.action();
        Action other$action = other.action();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionButton;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        BaseComponent $label = this.label();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        BaseComponent $tooltip = this.tooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        Action $action = this.action();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ActionButton(label=" + this.label() + ", tooltip=" + this.tooltip() + ", width=" + this.width() + ", action=" + this.action() + ")";
    }
}

