/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.action.ActionButton;

public final class MultiActionDialog
implements Dialog {
    @NonNull
    private DialogBase base;
    @NonNull
    private List<ActionButton> actions;
    private Integer columns;
    @SerializedName(value="exit_action")
    private ActionButton exitAction;

    public MultiActionDialog(@NonNull DialogBase base, ActionButton ... actions) {
        this(base, Arrays.asList(actions), null, null);
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
    }

    public MultiActionDialog(@NonNull DialogBase base, @NonNull List<ActionButton> actions, Integer columns, ActionButton exitAction) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        Preconditions.checkArgument((!actions.isEmpty() ? 1 : 0) != 0, (Object)"At least one action must be provided");
        this.base = base;
        this.actions = actions;
        this.columns(columns);
        this.exitAction = exitAction;
    }

    public MultiActionDialog columns(Integer columns) {
        Preconditions.checkArgument((columns == null || columns > 0 ? 1 : 0) != 0, (Object)"At least one column is required");
        this.columns = columns;
        return this;
    }

    @Override
    @NonNull
    @Generated
    public DialogBase getBase() {
        return this.base;
    }

    @NonNull
    @Generated
    public List<ActionButton> actions() {
        return this.actions;
    }

    @Generated
    public Integer columns() {
        return this.columns;
    }

    @Generated
    public ActionButton exitAction() {
        return this.exitAction;
    }

    @Override
    @Generated
    public void setBase(@NonNull DialogBase base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    @Generated
    public MultiActionDialog actions(@NonNull List<ActionButton> actions) {
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        this.actions = actions;
        return this;
    }

    @Generated
    public MultiActionDialog exitAction(ActionButton exitAction) {
        this.exitAction = exitAction;
        return this;
    }

    @Generated
    public String toString() {
        return "MultiActionDialog(base=" + this.getBase() + ", actions=" + this.actions() + ", columns=" + this.columns() + ", exitAction=" + this.exitAction() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiActionDialog)) {
            return false;
        }
        MultiActionDialog other = (MultiActionDialog)o;
        Integer this$columns = this.columns();
        Integer other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        DialogBase this$base = this.getBase();
        DialogBase other$base = other.getBase();
        if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
            return false;
        }
        List<ActionButton> this$actions = this.actions();
        List<ActionButton> other$actions = other.actions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        ActionButton this$exitAction = this.exitAction();
        ActionButton other$exitAction = other.exitAction();
        return !(this$exitAction == null ? other$exitAction != null : !((Object)this$exitAction).equals(other$exitAction));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $columns = this.columns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        DialogBase $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        List<ActionButton> $actions = this.actions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        ActionButton $exitAction = this.exitAction();
        result = result * 59 + ($exitAction == null ? 43 : ((Object)$exitAction).hashCode());
        return result;
    }
}

