/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.PluginClassloader;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.api.plugin.PluginLogger;
import net.md_5.bungee.api.scheduler.GroupedThreadFactory;
import org.jetbrains.annotations.ApiStatus;

public class Plugin {
    private PluginDescription description;
    private ProxyServer proxy;
    private File file;
    private Logger logger;
    private ExecutorService service;

    public Plugin() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Preconditions.checkState((boolean)(classLoader instanceof PluginClassloader), (Object)("Plugin requires " + PluginClassloader.class.getName()));
        ((PluginClassloader)classLoader).init(this);
    }

    protected Plugin(ProxyServer proxy, PluginDescription description) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Preconditions.checkState((!(classLoader instanceof PluginClassloader) ? 1 : 0) != 0, (Object)"Cannot use initialization constructor at runtime");
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public final File getDataFolder() {
        return new File(this.getProxy().getPluginsFolder(), this.getDescription().getName());
    }

    public final InputStream getResourceAsStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    final void init(ProxyServer proxy, PluginDescription description) {
        this.proxy = proxy;
        this.description = description;
        this.file = description.getFile();
        this.logger = new PluginLogger(this);
    }

    @Deprecated
    @ApiStatus.Internal
    public ExecutorService getExecutorService() {
        if (this.service == null) {
            String name = this.getDescription() == null ? "unknown" : this.getDescription().getName();
            this.service = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(name + " Pool Thread #%1$d").setThreadFactory((ThreadFactory)new GroupedThreadFactory(this, name)).build());
        }
        return this.service;
    }

    @Generated
    public PluginDescription getDescription() {
        return this.description;
    }

    @Generated
    public ProxyServer getProxy() {
        return this.proxy;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

