/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.time.LocalDateTime;
import java.util.Arrays;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.TIMESTAMP;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonTimestampImpl
implements OracleJsonTimestamp {
    byte[] raw;

    public OracleJsonTimestampImpl(byte[] byArray) {
        this.raw = byArray;
    }

    public OracleJsonTimestampImpl(LocalDateTime localDateTime) {
        this.raw = OsonPrimitiveConversions.toOracleTimestamp(this.getExceptionFactory(), localDateTime);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.TIMESTAMP;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonTimestamp)) {
            return false;
        }
        if (!(object instanceof OracleJsonTimestampImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonTimestampImpl oracleJsonTimestampImpl = (OracleJsonTimestampImpl)object;
        return Arrays.equals(oracleJsonTimestampImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.timestampToString(this.getExceptionFactory(), this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        byte[] byArray = this.raw();
        return OsonPrimitiveConversions.timestampToLocalDateTime(this.getExceptionFactory(), byArray);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public TIMESTAMP getTIMESTAMP() {
        return new TIMESTAMP(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaTimestampImpl(this.raw));
        }
        return clazz.cast(new JsonpPrimitive.JsonpTimestampImpl(this.raw));
    }

    public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }
}

