/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.AbstractNoCacheHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.CachePingOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class NoCachePingOperation
extends AbstractNoCacheHotRodOperation<PingResponse> {
    private static final Log log = LogFactory.getLog(CachePingOperation.class);
    private final PingResponse.Decoder pingDecoder = new PingResponse.Decoder();

    @Override
    public PingResponse createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        this.pingDecoder.processResponse(null, buf, decoder);
        if (HotRodConstants.isSuccess(status)) {
            PingResponse pingResponse = this.pingDecoder.build(status);
            decoder.setCodec(pingResponse.getVersion().getCodec());
            return pingResponse;
        }
        String hexStatus = Integer.toHexString(status);
        if (log.isTraceEnabled()) {
            log.tracef("Unknown response status: %s", hexStatus);
        }
        throw new InvalidResponseException("Unexpected response status: " + hexStatus);
    }

    @Override
    public short requestOpCode() {
        return 23;
    }

    @Override
    public short responseOpCode() {
        return 24;
    }
}

