/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.ThreadSafe;
import java.nio.ByteBuffer;
import java.util.Arrays;

@ThreadSafe
public final class ByteBuffers {
    public static boolean equals(ByteBuffer buffer, byte[] array) {
        if (buffer == null && array == null) {
            return true;
        }
        if (buffer == null || array == null) {
            return false;
        }
        if (buffer.remaining() != array.length) {
            return false;
        }
        if (buffer.hasArray()) {
            byte[] bufferArray = buffer.array();
            int bufferOffset = buffer.arrayOffset();
            int bufferLength = buffer.remaining();
            return Arrays.equals(bufferArray, bufferOffset, bufferOffset + bufferLength, array, 0, array.length);
        }
        int originalPosition = buffer.position();
        for (int i = 0; i < array.length; ++i) {
            if (buffer.get(originalPosition + i) == array[i]) continue;
            return false;
        }
        return true;
    }
}

