/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class IsoDate {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE;
    public static final String SCHEMA_NAME = "io.debezium.time.IsoDate";

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(Integer.valueOf(1));
    }

    public static Schema schema() {
        return IsoDate.builder().build();
    }

    public static String toIsoString(Object value, TemporalAdjuster adjuster) {
        LocalDate date = Conversions.toLocalDate(value);
        if (adjuster != null) {
            date = date.with(adjuster);
        }
        ZonedDateTime zonedDate = ZonedDateTime.of(date, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        return zonedDate.format(FORMATTER);
    }

    private IsoDate() {
    }
}

