/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.DebeziumException;
import io.debezium.relational.Attribute;
import io.debezium.relational.AttributeEditor;
import io.debezium.relational.AttributeImpl;
import java.math.BigDecimal;
import java.math.BigInteger;

final class AttributeEditorImpl
implements AttributeEditor {
    private String name;
    private String value;

    protected AttributeEditorImpl() {
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Integer asInteger() {
        return this.value == null ? null : Integer.valueOf(Integer.parseInt(this.value));
    }

    @Override
    public Long asLong() {
        return this.value == null ? null : Long.valueOf(Long.parseLong(this.value));
    }

    @Override
    public Boolean asBoolean() {
        return this.value == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.value));
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value == null ? null : new BigInteger(this.value);
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.value == null ? null : new BigDecimal(this.value);
    }

    @Override
    public Float asFloat() {
        return this.value == null ? null : Float.valueOf(Float.parseFloat(this.value));
    }

    @Override
    public Double asDouble() {
        return this.value == null ? null : Double.valueOf(Double.parseDouble(this.value));
    }

    @Override
    public AttributeEditor name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public AttributeEditor value(Object value) {
        if (value == null) {
            this.value = null;
        } else if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof Integer) {
            this.value = Integer.toString((Integer)value);
        } else if (value instanceof Long) {
            this.value = Long.toString((Long)value);
        } else if (value instanceof Boolean) {
            this.value = Boolean.toString((Boolean)value);
        } else if (value instanceof BigInteger) {
            this.value = value.toString();
        } else if (value instanceof BigDecimal) {
            this.value = value.toString();
        } else if (value instanceof Float) {
            this.value = Float.toString(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.value = Double.toString((Double)value);
        } else {
            throw new DebeziumException(value.getClass().getName() + " cannot be used for attribute values");
        }
        return this;
    }

    @Override
    public Attribute create() {
        return new AttributeImpl(this.name, this.value);
    }

    public String toString() {
        return this.create().toString();
    }
}

