/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.txmetadata;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.pipeline.txmetadata.TransactionStatus;
import io.debezium.pipeline.txmetadata.TransactionStructMaker;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractTransactionStructMaker
implements TransactionStructMaker {
    protected static final Schema EVENT_COUNT_PER_DATA_COLLECTION_SCHEMA = SchemaFactory.get().transactionEventCountPerDataCollectionSchema();
    protected Schema transactionKeySchema;
    protected Schema transactionValueSchema;

    public AbstractTransactionStructMaker(Configuration config) {
        SchemaNameAdjuster adjuster = CommonConnectorConfig.SchemaNameAdjustmentMode.parse(config.getString(CommonConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE)).createAdjuster();
        this.transactionKeySchema = SchemaFactory.get().transactionKeySchema(adjuster);
        this.transactionValueSchema = SchemaFactory.get().transactionValueSchema(adjuster);
    }

    @Override
    public Struct addTransactionBlock(OffsetContext offsetContext, long dataCollectionEventOrder, Struct value) {
        TransactionContext transactionContext = offsetContext.getTransactionContext();
        Struct txStruct = new Struct(this.getTransactionBlockSchema());
        txStruct.put("id", (Object)transactionContext.getTransactionId());
        txStruct.put("total_order", (Object)transactionContext.getTotalEventCount());
        txStruct.put("data_collection_order", (Object)dataCollectionEventOrder);
        return txStruct;
    }

    @Override
    public Struct buildEndTransactionValue(OffsetContext offsetContext, Instant timestamp) {
        TransactionContext transactionContext = offsetContext.getTransactionContext();
        Struct value = new Struct(this.getTransactionValueSchema());
        value.put("status", (Object)TransactionStatus.END.name());
        value.put("id", (Object)transactionContext.getTransactionId());
        value.put("ts_ms", (Object)timestamp.toEpochMilli());
        value.put("event_count", (Object)transactionContext.getTotalEventCount());
        Set<Map.Entry<String, Long>> perTableEventCount = transactionContext.getPerTableEventCount().entrySet();
        ArrayList<Struct> valuePerTableCount = new ArrayList<Struct>(perTableEventCount.size());
        for (Map.Entry<String, Long> tableEventCount : perTableEventCount) {
            Struct perTable = new Struct(this.getEventCountPerDataCollectionSchema());
            perTable.put("data_collection", (Object)tableEventCount.getKey());
            perTable.put("event_count", (Object)tableEventCount.getValue());
            valuePerTableCount.add(perTable);
        }
        value.put("data_collections", valuePerTableCount);
        return value;
    }

    @Override
    public Struct buildBeginTransactionValue(OffsetContext offsetContext, Instant timestamp) {
        TransactionContext transactionContext = offsetContext.getTransactionContext();
        Struct value = new Struct(this.getTransactionValueSchema());
        value.put("status", (Object)TransactionStatus.BEGIN.name());
        value.put("id", (Object)transactionContext.getTransactionId());
        value.put("ts_ms", (Object)timestamp.toEpochMilli());
        return value;
    }

    @Override
    public Struct buildTransactionKey(OffsetContext offsetContext) {
        TransactionContext transactionContext = offsetContext.getTransactionContext();
        Struct key = new Struct(this.getTransactionKeySchema());
        key.put("id", (Object)transactionContext.getTransactionId());
        return key;
    }

    @Override
    public Schema getEventCountPerDataCollectionSchema() {
        return EVENT_COUNT_PER_DATA_COLLECTION_SCHEMA;
    }

    @Override
    public Schema getTransactionKeySchema() {
        return this.transactionKeySchema;
    }

    @Override
    public Schema getTransactionValueSchema() {
        return this.transactionValueSchema;
    }
}

