/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.heartbeat.CompositeHeartbeat;
import io.debezium.heartbeat.DatabaseHeartbeatFactory;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.heartbeat.DebeziumHeartbeatFactory;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.heartbeat.HeartbeatConnectionProvider;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.heartbeat.HeartbeatImpl;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public class HeartbeatFactory<T extends DataCollectionId>
implements DebeziumHeartbeatFactory {
    private final CommonConnectorConfig connectorConfig;
    private final TopicNamingStrategy<T> topicNamingStrategy;
    private final SchemaNameAdjuster schemaNameAdjuster;
    private final HeartbeatConnectionProvider connectionProvider;
    private final HeartbeatErrorHandler errorHandler;
    private final ServiceLoader<DebeziumHeartbeatFactory> externalHeartbeatFactory = ServiceLoader.load(DebeziumHeartbeatFactory.class);
    private final List<DebeziumHeartbeatFactory> heartbeatFactories = new ArrayList<DebeziumHeartbeatFactory>();

    @Deprecated
    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicNamingStrategy<T> topicNamingStrategy, SchemaNameAdjuster schemaNameAdjuster) {
        this(connectorConfig, topicNamingStrategy, schemaNameAdjuster, null, null);
    }

    @Deprecated
    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicNamingStrategy<T> topicNamingStrategy, SchemaNameAdjuster schemaNameAdjuster, HeartbeatConnectionProvider connectionProvider, HeartbeatErrorHandler errorHandler) {
        this.connectorConfig = connectorConfig;
        this.topicNamingStrategy = topicNamingStrategy;
        this.schemaNameAdjuster = schemaNameAdjuster;
        this.connectionProvider = connectionProvider;
        this.errorHandler = errorHandler;
        this.heartbeatFactories.add(new DatabaseHeartbeatFactory());
        this.heartbeatFactories.addAll(this.externalHeartbeatFactory.stream().map(ServiceLoader.Provider::get).toList());
    }

    public HeartbeatFactory() {
        this.connectorConfig = null;
        this.topicNamingStrategy = null;
        this.schemaNameAdjuster = null;
        this.connectionProvider = null;
        this.errorHandler = null;
        this.heartbeatFactories.add(new DatabaseHeartbeatFactory());
        this.heartbeatFactories.addAll(this.externalHeartbeatFactory.stream().map(ServiceLoader.Provider::get).toList());
    }

    @Deprecated
    public Heartbeat createHeartbeat() {
        RelationalDatabaseConnectorConfig relConfig;
        if (this.connectorConfig.getHeartbeatInterval().isZero()) {
            return Heartbeat.DEFAULT_NOOP_HEARTBEAT;
        }
        HeartbeatImpl scheduledHeartbeat = new HeartbeatImpl(this.connectorConfig.getHeartbeatInterval(), this.topicNamingStrategy.heartbeatTopic(), this.connectorConfig.getLogicalName(), this.schemaNameAdjuster);
        CommonConnectorConfig commonConnectorConfig = this.connectorConfig;
        if (commonConnectorConfig instanceof RelationalDatabaseConnectorConfig && !Strings.isNullOrBlank((relConfig = (RelationalDatabaseConnectorConfig)commonConnectorConfig).getHeartbeatActionQuery())) {
            return new CompositeHeartbeat((Heartbeat.ScheduledHeartbeat)scheduledHeartbeat, new DatabaseHeartbeatImpl(this.connectionProvider.get(), relConfig.getHeartbeatActionQuery(), this.errorHandler));
        }
        return scheduledHeartbeat;
    }

    @Override
    public Heartbeat.ScheduledHeartbeat getScheduledHeartbeat(CommonConnectorConfig connectorConfig, HeartbeatConnectionProvider connectionProvider, HeartbeatErrorHandler errorHandler, ChangeEventQueue<DataChangeEvent> queue) {
        if (connectorConfig.getHeartbeatInterval().isZero()) {
            return Heartbeat.ScheduledHeartbeat.NOOP_HEARTBEAT;
        }
        List<Heartbeat> heartbeats = this.heartbeatFactories.stream().map(factory -> factory.getHeartbeat(connectorConfig, connectionProvider, errorHandler, queue)).flatMap(Optional::stream).toList();
        return new CompositeHeartbeat((Heartbeat.ScheduledHeartbeat)new HeartbeatImpl(connectorConfig.getHeartbeatInterval(), connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY).heartbeatTopic(), connectorConfig.getLogicalName(), connectorConfig.schemaNameAdjuster(), queue), heartbeats);
    }
}

