/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.document.BasicField;
import io.debezium.document.Document;
import io.debezium.document.DocumentWriter;
import io.debezium.document.Value;
import io.debezium.util.Iterators;
import io.debezium.util.MathOps;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

@NotThreadSafe
final class BasicDocument
implements Document {
    static final Function<Map.Entry<? extends CharSequence, Value>, Document.Field> CONVERT_ENTRY_TO_FIELD = new Function<Map.Entry<? extends CharSequence, Value>, Document.Field>(){

        @Override
        public Document.Field apply(Map.Entry<? extends CharSequence, Value> entry) {
            return new BasicField(entry.getKey(), entry.getValue());
        }
    };
    private final Map<CharSequence, Value> fields = new LinkedHashMap<CharSequence, Value>();

    BasicDocument() {
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public int compareTo(Document that) {
        return this.compareTo(that, true);
    }

    @Override
    public int compareToUsingSimilarFields(Document that) {
        if (that == null) {
            return 1;
        }
        int diff = 0;
        for (Map.Entry<CharSequence, Value> entry : this.fields.entrySet()) {
            CharSequence key = entry.getKey();
            diff = this.compareNonNull(this.get(key), that.get(key));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    public int compareToWithoutFieldOrder(Document that) {
        return this.compareTo(that, false);
    }

    @Override
    public int compareTo(Document that, boolean enforceFieldOrder) {
        if (that == null) {
            return 1;
        }
        if (this.size() != that.size()) {
            return this.size() - that.size();
        }
        int diff = 0;
        if (enforceFieldOrder) {
            Iterator<CharSequence> thisIter = this.keySet().iterator();
            Iterator<CharSequence> thatIter = that.keySet().iterator();
            while (thisIter.hasNext() && thatIter.hasNext()) {
                String thatKey;
                String thisKey = thisIter.next().toString();
                diff = thisKey.compareTo(thatKey = thatIter.next().toString());
                if (diff != 0) {
                    return diff;
                }
                diff = this.compare(this.get(thisKey), that.get(thatKey));
                if (diff == 0) continue;
                return diff;
            }
            if (thisIter.hasNext()) {
                return 1;
            }
            if (thatIter.hasNext()) {
                return -1;
            }
        } else {
            for (Map.Entry<CharSequence, Value> entry : this.fields.entrySet()) {
                CharSequence key = entry.getKey();
                diff = this.compare(this.get(key), that.get(key));
                if (diff == 0) continue;
                return diff;
            }
            if (that.size() > this.size()) {
                return 1;
            }
        }
        return 0;
    }

    protected int compare(Value value1, Value value2) {
        if (value1 == null) {
            return Value.isNull(value2) ? 0 : 1;
        }
        return value1.comparable().compareTo(value2.comparable());
    }

    protected int compareNonNull(Value value1, Value value2) {
        if (Value.isNull(value1) || Value.isNull(value2)) {
            return 0;
        }
        return value1.comparable().compareTo(value2.comparable());
    }

    @Override
    public Iterable<CharSequence> keySet() {
        return this.fields.keySet();
    }

    @Override
    public Iterator<Document.Field> iterator() {
        return Iterators.around(this.fields.entrySet(), CONVERT_ENTRY_TO_FIELD);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    @Override
    public boolean has(CharSequence fieldName) {
        return this.fields.containsKey(fieldName);
    }

    @Override
    public boolean hasAll(Document that) {
        if (that == null) {
            return true;
        }
        if (this.size() < that.size()) {
            return false;
        }
        return that.stream().allMatch(field -> {
            Value thatValue = field.getValue();
            Value thisValue = this.get(field.getName());
            return Value.compareTo(thisValue, thatValue) == 0;
        });
    }

    @Override
    public Value get(CharSequence fieldName, Comparable<?> defaultValue) {
        Value value = this.fields.get(fieldName);
        return value != null ? value : Value.create(defaultValue);
    }

    @Override
    public Document putAll(Iterable<Document.Field> object) {
        object.forEach(this::setValue);
        return this;
    }

    @Override
    public Document removeAll() {
        this.fields.clear();
        return this;
    }

    @Override
    public Value remove(CharSequence name) {
        if (!this.fields.containsKey(name)) {
            return null;
        }
        Comparable removedValue = this.fields.remove(name);
        return Value.create(removedValue);
    }

    @Override
    public Document setValue(CharSequence name, Value value) {
        this.fields.put(name, value != null ? value.clone() : Value.nullValue());
        return this;
    }

    @Override
    public Document increment(CharSequence name, Value increment) {
        if (!increment.isNumber()) {
            throw new IllegalArgumentException("The increment must be a number but is " + String.valueOf(increment));
        }
        if (this.fields.containsKey(name)) {
            Number current = this.getNumber(name);
            if (current != null) {
                Value updated = Value.create(MathOps.add(current, increment.asNumber()));
                this.setValue(name, Value.create(updated));
            }
        } else {
            this.setValue(name, increment);
        }
        return this;
    }

    @Override
    public Document clone() {
        return new BasicDocument().putAll(this);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicDocument) {
            BasicDocument that = (BasicDocument)obj;
            return this.fields.equals(that.fields);
        }
        if (obj instanceof Document) {
            Document that = (Document)obj;
            return this.hasAll(that) && that.hasAll(this);
        }
        return false;
    }

    public String toString() {
        try {
            return DocumentWriter.prettyWriter().write(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

