/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Vectors {
    private static final String SPARSE_VECTOR_ERROR = "Cannot convert sparse vector {}, expected format is {i1:x,i2:y,i3:z,...}/dimensions";
    private static final Logger LOGGER = LoggerFactory.getLogger(Vectors.class);

    static <T> List<T> fromVectorString(Schema schema, String value, Function<String, T> elementMapper) {
        Objects.requireNonNull(value, "value may not be null");
        value = value.trim();
        if (!value.startsWith("[") || !value.endsWith("]")) {
            LOGGER.warn("Cannot convert vector {}, expected format is [x,y,z,...]", (Object)value);
            return null;
        }
        value = value.substring(1, value.length() - 1);
        String[] strValues = value.split(",");
        ArrayList<T> result = new ArrayList<T>(strValues.length);
        for (String element : strValues) {
            result.add(elementMapper.apply(element.trim()));
        }
        return result;
    }

    static <T> Struct fromSparseVectorString(Schema schema, String value, Function<String, T> elementMapper) {
        Objects.requireNonNull(value, "value may not be null");
        value = value.trim();
        String[] parts = value.split("/");
        if (parts.length != 2) {
            LOGGER.warn(SPARSE_VECTOR_ERROR, (Object)value);
            return null;
        }
        String strVector = parts[0].trim();
        short dimensions = Short.parseShort(parts[1].trim());
        if (!strVector.startsWith("{") || !strVector.endsWith("}")) {
            LOGGER.warn(SPARSE_VECTOR_ERROR, (Object)value);
            return null;
        }
        strVector = strVector.substring(1, strVector.length() - 1);
        String[] strValues = strVector.split(",");
        HashMap<Short, T> vector = new HashMap<Short, T>(strValues.length);
        for (String element : strValues) {
            parts = element.split(":");
            if (parts.length != 2) {
                LOGGER.warn(SPARSE_VECTOR_ERROR, (Object)value);
                return null;
            }
            vector.put(Short.parseShort(parts[0].trim()), elementMapper.apply(parts[1].trim()));
        }
        Struct result = new Struct(schema);
        result.put("dimensions", (Object)dimensions);
        result.put("vector", vector);
        return result;
    }
}

