/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.DebeziumException;
import java.util.Map;

public final class OffsetUtils {
    public static long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new DebeziumException("Source offset '" + key + "' parameter value " + String.valueOf(obj) + " could not be converted to a long");
        }
    }

    public static String stringOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return null;
        }
        return (String)obj;
    }

    public static boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    private OffsetUtils() {
    }
}

