/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.bean;

import io.debezium.bean.NoSuchBeanException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.common.annotation.Incubating;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Incubating
public class DefaultBeanRegistry
implements BeanRegistry {
    private final Map<String, Map<Class<?>, Object>> registry = new LinkedHashMap();

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> results = new LinkedHashSet<T>();
        for (Map.Entry<String, Map<Class<?>, Object>> entry : this.registry.entrySet()) {
            for (Object value : entry.getValue().values()) {
                if (!type.isInstance(value)) continue;
                results.add(type.cast(value));
            }
        }
        return results;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap<String, T> results = new LinkedHashMap<String, T>();
        for (Map.Entry<String, Map<Class<?>, Object>> entry : this.registry.entrySet()) {
            for (Object value : entry.getValue().values()) {
                if (!type.isInstance(value)) continue;
                results.put(entry.getKey(), type.cast(value));
            }
        }
        return results;
    }

    @Override
    public <T> T lookupByName(String name, Class<T> type) {
        Map<Class<?>, Object> map = this.registry.get(name);
        if (map == null) {
            return null;
        }
        Object value = this.getMapValueWithFallbackTypeLookup(map, type);
        if (value == null) {
            return null;
        }
        try {
            return type.cast(value);
        }
        catch (Exception e) {
            String message = String.format("Found bean '%s' with type '%s', expected type '%s'", name, value.getClass().getName(), type);
            throw new NoSuchBeanException(name, message, e);
        }
    }

    @Override
    public void add(String name, Class<?> type, Object bean) {
        Objects.requireNonNull(name, "Cannot add a bean to the registry with no name.");
        Objects.requireNonNull(type, "Cannot add a bean to the registry with no class type.");
        Objects.requireNonNull(bean, "Cannot add a null bean to the registry.");
        this.registry.computeIfAbsent(name, k -> new LinkedHashMap()).put(type, bean);
    }

    @Override
    public void add(String name, Object bean) {
        Objects.requireNonNull(bean, "Cannot add a null bean to the registry.");
        this.add(name, bean.getClass(), bean);
    }

    @Override
    public void remove(String name) {
        this.registry.remove(name);
    }

    private <T> Object findMapValueByType(Map<Class<?>, Object> map, Class<T> type) {
        for (Object value : map.values()) {
            if (!type.isInstance(value)) continue;
            return value;
        }
        return null;
    }

    private <T> Object getMapValueWithFallbackTypeLookup(Map<Class<?>, Object> map, Class<T> type) {
        Object value = map.get(type);
        return value != null ? value : this.findMapValueByType(map, type);
    }
}

