/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.olr.client.PayloadEvent;
import java.io.IOException;
import java.time.Instant;
import java.util.List;

public class StreamingEvent {
    @JsonDeserialize(using=ScnDeserializer.class)
    private Scn scn;
    @JsonProperty(value="tm")
    @JsonDeserialize(using=TimestampAsInstantDeserializer.class)
    private Instant timestamp;
    private String xid;
    @JsonProperty(value="db")
    private String databaseName;
    @JsonProperty(value="c_scn")
    @JsonDeserialize(using=ScnDeserializer.class)
    private Scn checkpointScn;
    @JsonProperty(value="c_idx")
    private Long checkpointIndex;
    private List<PayloadEvent> payload;

    public Scn getScn() {
        return this.scn;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getXid() {
        return this.xid;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Scn getCheckpointScn() {
        return this.checkpointScn;
    }

    public Long getCheckpointIndex() {
        return this.checkpointIndex;
    }

    public List<PayloadEvent> getPayload() {
        return this.payload;
    }

    public String toString() {
        return "StreamingEvent{scn='" + String.valueOf(this.scn) + "', timestamp='" + String.valueOf(this.timestamp) + "', xid='" + this.xid + "', databaseName='" + this.databaseName + "', checkpointScn='" + String.valueOf(this.checkpointScn) + "', checkpointIndex=" + this.checkpointIndex + ", payload=" + String.valueOf(this.payload) + "}";
    }

    static class TimestampAsInstantDeserializer
    extends StdDeserializer<Instant> {
        TimestampAsInstantDeserializer() {
            super(Instant.class);
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String timestamp = jsonParser.getText();
            try {
                return Instant.ofEpochMilli(Long.parseLong(timestamp));
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to deserialize timestamp as instant: " + timestamp);
            }
        }
    }

    static class ScnDeserializer
    extends StdDeserializer<Scn> {
        ScnDeserializer() {
            super(Scn.class);
        }

        public Scn deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String scn = jsonParser.getText();
            try {
                return scn == null ? Scn.NULL : Scn.valueOf(scn);
            }
            catch (Exception e) {
                throw new IOException("Failed to deserialize SCN: " + scn);
            }
        }
    }
}

