/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.unbuffered;

import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.AbstractLogMinerStreamingChangeEventSource;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.TransactionCommitConsumer;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.events.RedoSqlDmlEvent;
import io.debezium.connector.oracle.logminer.events.TruncateEvent;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.unbuffered.ResumePositionProvider;
import io.debezium.connector.oracle.logminer.unbuffered.UnbufferedLogMinerQueryBuilder;
import io.debezium.data.Envelope;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Loggings;
import io.debezium.util.Stopwatch;
import io.debezium.util.Strings;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class UnbufferedLogMinerStreamingChangeEventSource
extends AbstractLogMinerStreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnbufferedLogMinerStreamingChangeEventSource.class);
    private final String miningQuery;
    private final boolean includeSql;
    private final TransactionCommitConsumer accumulator;
    private final List<LogMinerEventRow> ddlQueue = new ArrayList<LogMinerEventRow>();
    private final ResumePositionProvider resumePositionProvider;
    private boolean skipCurrentTransaction = false;
    private ZoneOffset databaseOffset;
    private Scn lastCommitScn = Scn.NULL;

    public UnbufferedLogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, LogMinerStreamingChangeEventSourceMetrics metrics) {
        super(connectorConfig, jdbcConnection, dispatcher, errorHandler, clock, schema, jdbcConfig, metrics);
        this.miningQuery = new UnbufferedLogMinerQueryBuilder(connectorConfig).getQuery();
        this.includeSql = connectorConfig.isLogMiningIncludeRedoSql();
        this.accumulator = new TransactionCommitConsumer(this::dispatchEvent, connectorConfig, schema);
        this.resumePositionProvider = new ResumePositionProvider(connectorConfig, this.getJdbcConfiguration());
    }

    @Override
    protected void executeLogMiningStreaming() throws Exception {
        Scn upperBoundsScn = Scn.NULL;
        Scn minLogScn = this.getOffsetContext().getScn();
        Scn minCommitScn = this.getOffsetContext().getCommitScn().getMinCommittedScn();
        if (minCommitScn.isNull()) {
            minCommitScn = minLogScn;
        }
        Stopwatch watch = Stopwatch.accumulating().start();
        int miningStartAttempts = 1;
        this.prepareLogsForMining(false, minLogScn);
        while (!(!this.getContext().isRunning() || this.getConfig().isArchiveLogOnlyMode() && this.waitForRangeAvailabilityInArchiveLogs(minLogScn, upperBoundsScn))) {
            Instant batchStartTime = Instant.now();
            this.updateDatabaseTimeDifference();
            this.databaseOffset = this.getMetrics().getDatabaseOffset();
            minLogScn = this.computeResumeScnAndUpdateOffsets(minLogScn, minCommitScn);
            this.getMetrics().setOffsetScn(minLogScn);
            Scn currentScn = this.getCurrentScn();
            this.getMetrics().setCurrentScn(currentScn);
            upperBoundsScn = this.calculateUpperBounds(minLogScn, upperBoundsScn, currentScn);
            if (upperBoundsScn.isNull()) {
                LOGGER.debug("Delaying mining transaction logs by one iteration");
                this.pauseBetweenMiningSessions();
                continue;
            }
            boolean miningSessionRestartRequired = this.isMiningSessionRestartRequired(watch);
            if (miningSessionRestartRequired || this.checkLogSwitchOccurredAndUpdate()) {
                this.endMiningSession();
                if (miningSessionRestartRequired || this.getConfig().isLogMiningRestartConnection()) {
                    this.prepareJdbcConnection(true);
                }
                this.prepareLogsForMining(true, minLogScn);
                watch = Stopwatch.accumulating().start();
            }
            if (this.startMiningSession(minLogScn, Scn.NULL, miningStartAttempts)) {
                miningStartAttempts = 1;
                minCommitScn = this.process(minCommitScn, upperBoundsScn);
                this.getMetrics().setLastBatchProcessingDuration(Duration.between(batchStartTime, Instant.now()));
            } else {
                ++miningStartAttempts;
            }
            this.captureJdbcSessionMemoryStatistics();
            this.pauseBetweenMiningSessions();
            if (!this.getContext().isPaused()) continue;
            Scn currentOffsetScn = this.getOffsetContext().getScn();
            this.getOffsetContext().setScn(minCommitScn);
            this.executeBlockingSnapshot();
            this.getOffsetContext().setScn(currentOffsetScn);
        }
    }

    @Override
    protected boolean isUsingCommittedDataOnly() {
        return true;
    }

    public void close() {
        try {
            this.resumePositionProvider.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to gracefully shutdown the resume position provider", (Throwable)e);
        }
    }

    @Override
    protected void enqueueEvent(LogMinerEventRow event, LogMinerEvent dispatchedEvent) throws InterruptedException {
        this.getMetrics().calculateLagFromSource(event.getChangeTime());
        this.accumulator.accept(dispatchedEvent);
    }

    @Override
    protected void executeDataChangeEventPreDispatchSteps(LogMinerEventRow event) throws InterruptedException {
        if (!this.ddlQueue.isEmpty()) {
            if (!event.getCommitScn().equals(this.getOffsetContext().getEventCommitScn())) {
                this.getOffsetContext().setEventCommitScn(event.getCommitScn());
            }
            this.dispatchSchemaChanges();
        }
    }

    private Scn computeResumeScnAndUpdateOffsets(Scn resumeScn, Scn commitScn) throws SQLException {
        Scn computedResumeScn = this.resumePositionProvider.computeResumePositionFromLogs(resumeScn, commitScn, this.getCurrentLogFiles());
        if (!computedResumeScn.equals(resumeScn)) {
            LOGGER.debug("Advancing offset low-watermark scn to {}", (Object)computedResumeScn);
            this.getOffsetContext().setScn(computedResumeScn);
        }
        return computedResumeScn;
    }

    private PreparedStatement createQueryStatement() throws SQLException {
        PreparedStatement statement = this.getConnection().connection().prepareStatement(this.miningQuery, 1003, 1007, 1);
        statement.setQueryTimeout((int)this.getConnection().config().getQueryTimeout().toSeconds());
        return statement;
    }

    private Scn process(Scn minCommitScn, Scn upperBoundsScn) throws SQLException, InterruptedException {
        this.getBatchMetrics().reset();
        try (PreparedStatement statement = this.createQueryStatement();){
            LOGGER.debug("Fetching results with COMMIT_SCN >= {} and < {}", (Object)minCommitScn, (Object)upperBoundsScn);
            statement.setFetchSize(this.getConfig().getQueryFetchSize());
            statement.setFetchDirection(1000);
            statement.setString(1, minCommitScn.toString());
            statement.setString(2, upperBoundsScn.toString());
            if (this.getConfig().isLogMiningUseCteQuery()) {
                statement.setString(3, minCommitScn.toString());
                statement.setString(4, upperBoundsScn.toString());
            }
            this.lastCommitScn = minCommitScn;
            this.getMetrics().setLastMiningFetchRange(minCommitScn, upperBoundsScn);
            this.executeAndProcessQuery(statement);
            if (!minCommitScn.equals(this.lastCommitScn)) {
                LOGGER.debug("Adjusting Min Commit SCN from {} to {}.", (Object)minCommitScn, (Object)this.lastCommitScn);
            }
            this.clearSchemaChangeQueue();
            Scn scn = this.lastCommitScn;
            return scn;
        }
    }

    @Override
    protected void processEvent(LogMinerEventRow event) throws SQLException, InterruptedException {
        super.processEvent(event);
        if (EventType.COMMIT.equals((Object)event.getEventType())) {
            this.lastCommitScn = event.getCommitScn();
            this.skipCurrentTransaction = false;
        }
    }

    @Override
    protected boolean isEventSkipped(LogMinerEventRow event) {
        return this.skipCurrentTransaction || this.isEventIncludedInSnapshot(event) || this.isNonSchemaChangeEventSkipped(event);
    }

    @Override
    protected boolean hasEventBeenProcessed(LogMinerEventRow event) {
        Scn scn;
        Scn scn2 = scn = event.getCommitScn().isNull() ? event.getScn() : event.getCommitScn();
        if (this.getOffsetContext().getCommitScn().hasBeenHandled(event.getThread(), scn, event.getTransactionId())) {
            return true;
        }
        if (Objects.equals(this.getOffsetContext().getTransactionId(), event.getTransactionId()) && this.getOffsetContext().getTransactionSequence() != null) {
            return this.getOffsetContext().getTransactionSequence() >= event.getTransactionSequence();
        }
        return false;
    }

    @Override
    protected void handleStartEvent(LogMinerEventRow event) {
        Instant commitTime;
        CommitScn offsetCommitScn;
        this.skipCurrentTransaction = false;
        if (!event.getCommitScn().isNull() && (offsetCommitScn = this.getOffsetContext().getCommitScn()).hasBeenHandled(event.getThread(), event.getCommitScn(), event.getTransactionId())) {
            LOGGER.info("Skipping transaction {} with SCN {}, already committed.", (Object)event.getTransactionId(), (Object)event.getScn());
            this.skipCurrentTransaction = true;
            return;
        }
        if (this.isUserNameSkipped(event.getUserName()) || this.isClientIdSkipped(event.getClientId())) {
            this.skipCurrentTransaction = true;
            return;
        }
        Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Starting transaction {} with SCN {}", (Object[])new Object[]{event.getTransactionId(), event.getScn()});
        Instant startTime = event.getStartTime();
        if (startTime != null) {
            startTime = startTime.minusSeconds(this.databaseOffset.getTotalSeconds());
        }
        if ((commitTime = event.getCommitTime()) != null) {
            commitTime = commitTime.minusSeconds(this.databaseOffset.getTotalSeconds());
        }
        this.getOffsetContext().setStartScn(event.getScn());
        this.getOffsetContext().setRedoThread(event.getThread());
        this.getOffsetContext().setStartTime(startTime);
        this.getOffsetContext().setCommitTime(commitTime);
        this.getOffsetContext().setEventCommitScn(event.getCommitScn());
        this.getOffsetContext().setUserName(event.getUserName());
        this.getOffsetContext().setTransactionId(event.getTransactionId());
        this.getOffsetContext().setTransactionSequence(null);
        this.getMetrics().setActiveTransactionCount(1L);
    }

    @Override
    protected void handleCommitEvent(LogMinerEventRow event) throws InterruptedException {
        Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Commit transaction {} at SCN {}.", (Object[])new Object[]{event.getTransactionId(), event.getScn()});
        Instant commitStartTime = Instant.now();
        this.getOffsetContext().getCommitScn().recordCommit(event);
        this.getOffsetContext().setEventScn(event.getScn());
        this.getOffsetContext().setEventCommitScn(event.getScn());
        if (!this.ddlQueue.isEmpty()) {
            this.dispatchSchemaChanges();
        }
        int numEvents = this.accumulator.getTotalEvents();
        this.accumulator.close();
        this.getEventDispatcher().dispatchTransactionCommittedEvent((Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), event.getChangeTime());
        this.getBatchMetrics().commitObserved();
        this.getMetrics().setActiveTransactionCount(0L);
        this.updateCommitMetrics(event, Duration.between(commitStartTime, Instant.now()), numEvents);
    }

    @Override
    protected void handleRollbackEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.accumulator.getTotalEvents() == 0) {
            LOGGER.warn("A rollback transaction {} with SCN {} detected with no captured changes", (Object)event.getTransactionId(), (Object)event.getScn());
            this.getMetrics().incrementWarningCount();
            this.accumulator.close();
            return;
        }
        throw new DebeziumException(String.format("Potential Oracle LogMiner Bug - Rollback transaction %s with SCN %s found emitted %d captured changes. A re-snapshot may be required. Please review your topics populated by this transaction.", event.getTransactionId(), event.getScn().toString(), this.accumulator.getTotalEvents()));
    }

    @Override
    protected void handleSchemaChangeEvent(LogMinerEventRow event) {
        if (this.isSchemaChangeEventSkipped(event)) {
            return;
        }
        if (!Strings.isNullOrBlank((String)event.getTableName())) {
            Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Processing DDL event with SCN {}: {}", (Object[])new Object[]{event.getScn(), event.getRedoSql()});
            this.ddlQueue.add(event);
        }
    }

    @Override
    protected void handleReplicationMarkerEvent(LogMinerEventRow event) {
        LOGGER.trace("Skipped GoldenGate replication marker event: {}", Loggings.maybeRedactSensitiveData((Object)event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTruncateEvent(LogMinerEventRow event) throws InterruptedException {
        try {
            Table table = this.getTableForDataEvent(event);
            if (table != null) {
                LOGGER.debug("Dispatching TRUNCATE event for table '{}' with SCN {}", (Object)table.id(), (Object)event.getScn());
                LogMinerDmlEntry parsedEvent = this.parseTruncateEvent(event);
                this.getOffsetContext().getCommitScn().recordCommit(event);
                this.getOffsetContext().setEventScn(event.getScn());
                this.getOffsetContext().setRedoThread(event.getThread());
                this.getOffsetContext().setRsId(event.getRsId());
                this.getOffsetContext().setRowId("");
                this.getOffsetContext().setTransactionId(event.getTransactionId());
                this.getOffsetContext().setTransactionSequence(event.getTransactionSequence());
                if (this.includeSql) {
                    this.getOffsetContext().setRedoSql(event.getRedoSql());
                }
                this.getEventDispatcher().dispatchDataChangeEvent((Partition)this.getPartition(), (DataCollectionId)table.id(), (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(this.getConfig(), (Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), Envelope.Operation.TRUNCATE, parsedEvent.getOldValues(), parsedEvent.getNewValues(), table, this.getSchema(), this.getClock()));
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to process truncate event", (Throwable)e);
            this.getMetrics().incrementWarningCount();
        }
        finally {
            if (this.includeSql) {
                this.getOffsetContext().setRedoSql("");
            }
        }
    }

    @Override
    protected boolean isNoDataProcessedInBatchAndAtEndOfArchiveLogs() {
        return !this.getMetrics().getBatchMetrics().hasProcessedAnyTransactions();
    }

    protected void dispatchEvent(LogMinerEvent event, long eventIndex, long eventsProcessed) throws InterruptedException {
        if (event instanceof TruncateEvent) {
            TruncateEvent truncateEvent = (TruncateEvent)event;
            int databaseOffsetSeconds = this.databaseOffset.getTotalSeconds();
            this.getMetrics().calculateLagFromSource(truncateEvent.getChangeTime());
            this.getOffsetContext().setEventScn(truncateEvent.getScn());
            this.getOffsetContext().setTransactionId(truncateEvent.getTransactionId());
            this.getOffsetContext().setTransactionSequence(truncateEvent.getTransactionSequence());
            this.getOffsetContext().setSourceTime(truncateEvent.getChangeTime().minusSeconds(databaseOffsetSeconds));
            this.getOffsetContext().setTableId(truncateEvent.getTableId());
            this.getOffsetContext().setRsId(truncateEvent.getRsId());
            this.getOffsetContext().setRowId(truncateEvent.getRowId());
            this.getEventDispatcher().dispatchDataChangeEvent((Partition)this.getPartition(), (DataCollectionId)truncateEvent.getTableId(), (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(this.getConfig(), (Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), Envelope.Operation.TRUNCATE, truncateEvent.getDmlEntry().getOldValues(), truncateEvent.getDmlEntry().getNewValues(), this.getSchema().tableFor(truncateEvent.getTableId()), this.getSchema(), Clock.system()));
        } else if (event instanceof DmlEvent) {
            DmlEvent dmlEvent = (DmlEvent)event;
            int databaseOffsetSeconds = this.databaseOffset.getTotalSeconds();
            this.getMetrics().calculateLagFromSource(dmlEvent.getChangeTime());
            this.getOffsetContext().setEventScn(dmlEvent.getScn());
            this.getOffsetContext().setTransactionId(dmlEvent.getTransactionId());
            this.getOffsetContext().setTransactionSequence(dmlEvent.getTransactionSequence());
            this.getOffsetContext().setSourceTime(dmlEvent.getChangeTime().minusSeconds(databaseOffsetSeconds));
            this.getOffsetContext().setTableId(dmlEvent.getTableId());
            this.getOffsetContext().setRsId(dmlEvent.getRsId());
            this.getOffsetContext().setRowId(dmlEvent.getRowId());
            if (event instanceof RedoSqlDmlEvent) {
                RedoSqlDmlEvent redoDmlEvent = (RedoSqlDmlEvent)event;
                this.getOffsetContext().setRedoSql(redoDmlEvent.getRedoSql());
            }
            this.getEventDispatcher().dispatchDataChangeEvent((Partition)this.getPartition(), (DataCollectionId)dmlEvent.getTableId(), (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(this.getConfig(), (Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), dmlEvent.getDmlEntry().getEventType(), dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), this.getSchema().tableFor(dmlEvent.getTableId()), this.getSchema(), Clock.system()));
        }
        this.getOffsetContext().setRedoSql(null);
    }

    private void dispatchSchemaChanges() throws InterruptedException {
        for (LogMinerEventRow event : this.ddlQueue) {
            this.dispatchSchemaChangeEventInternal(event);
        }
        this.ddlQueue.clear();
    }

    private void clearSchemaChangeQueue() {
        if (!this.ddlQueue.isEmpty()) {
            LOGGER.debug("Cleared uncommitted DDL change queue");
            this.ddlQueue.forEach(event -> Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"\tTransaction {} SCN {}: {}", (Object[])new Object[]{event.getTransactionId(), event.getScn(), event.getRedoSql()}));
            this.ddlQueue.clear();
        }
    }
}

