/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.unbuffered;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerSessionContext;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.util.Clock;
import io.debezium.util.HexConverter;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.SQLException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumePositionProvider
implements AutoCloseable {
    private final Logger LOGGER = LoggerFactory.getLogger(ResumePositionProvider.class);
    private final OracleConnectorConfig connectorConfig;
    private final JdbcConfiguration jdbcConfig;
    private final Duration updateInterval;
    private OracleConnection connection;
    private LogMinerSessionContext sessionContext;
    private volatile Threads.Timer queryTimer;

    public ResumePositionProvider(OracleConnectorConfig connectorConfig, JdbcConfiguration jdbcConfig) {
        this.connectorConfig = connectorConfig;
        this.jdbcConfig = jdbcConfig;
        this.updateInterval = connectorConfig.getResumePositionUpdateInterval();
        this.queryTimer = this.resetTimer();
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.LOGGER.info("Stopping the unbuffered resume position provider");
            this.sessionContext.close();
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scn computeResumePositionFromLogs(Scn currentResumeScn, Scn currentCommitScn, List<LogFile> logFiles) throws SQLException {
        if (!this.queryTimer.expired()) {
            return currentResumeScn;
        }
        try {
            if (this.connection == null) {
                this.LOGGER.info("Starting the unbuffered resume position provider");
                this.connection = new OracleConnection(this.connectorConfig, this.jdbcConfig);
                this.connection.setAutoCommit(false);
                if (!Strings.isNullOrEmpty((String)this.connectorConfig.getPdbName())) {
                    this.connection.resetSessionToCdb();
                }
                this.sessionContext = new LogMinerSessionContext(this.connection, false, OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, this.connectorConfig.getLogMiningPathToDictionary());
            }
            this.sessionContext.removeAllLogFilesFromSession();
            this.sessionContext.addLogFiles(logFiles);
            this.sessionContext.startSession(currentResumeScn, Scn.NULL, false);
            Scn resumeScn = (Scn)this.connection.prepareQueryAndMap("SELECT * FROM V$LOGMNR_CONTENTS WHERE OPERATION_CODE IN (6,7,36) AND SCN <= ?", ps -> ps.setString(1, currentCommitScn.toString()), rs -> {
                LinkedHashMap<String, Transaction> transactions = new LinkedHashMap<String, Transaction>();
                while (rs.next()) {
                    byte[] xid = rs.getBytes("XID");
                    String transactionId = xid == null ? null : HexConverter.convertToHexString((byte[])xid);
                    if (transactionId == null) continue;
                    EventType eventType = EventType.from(rs.getInt("OPERATION_CODE"));
                    Scn scn = Scn.valueOf(rs.getString("SCN"));
                    if (EventType.START == eventType) {
                        transactions.put(transactionId, new Transaction(scn));
                        continue;
                    }
                    Transaction transaction = (Transaction)transactions.get(transactionId);
                    if (transaction == null) {
                        this.LOGGER.trace("Ignoring transaction {} event {} at SCN {} as it must have started before current resume SCN {}.", new Object[]{transactionId, eventType, scn, currentResumeScn});
                        continue;
                    }
                    transaction.markEnded(scn);
                }
                return transactions.values().stream().filter(Transaction::isInProgress).findFirst().map(Transaction::getStartScn).orElse(currentCommitScn);
            });
            this.LOGGER.debug("Resume/Commit SCN {}/{} - new resume SCN is {}", new Object[]{currentResumeScn, currentCommitScn, resumeScn});
            Scn scn = resumeScn;
            return scn;
        }
        finally {
            this.sessionContext.endMiningSession();
            this.queryTimer = this.resetTimer();
        }
    }

    private Threads.Timer resetTimer() {
        return Threads.timer((Clock)Clock.SYSTEM, (Duration)this.updateInterval);
    }

    private static class Transaction {
        private final Scn startScn;
        private Scn endScn;

        Transaction(Scn startScn) {
            this.startScn = startScn;
        }

        public void markEnded(Scn scn) {
            this.endScn = scn;
        }

        public boolean isInProgress() {
            return this.endScn == null;
        }

        public Scn getStartScn() {
            return this.startScn;
        }
    }
}

