/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.util.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafe
public class LobWriteParser {
    private static Pattern SQL_PATTERN = Pattern.compile("(?s).* := ((?:HEXTORAW\\()?'.*'(?:\\))?);\\s*dbms_lob.write\\([^,]+,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,[^,]+\\);.*");

    public static LobWrite parse(String redoSql) {
        if (Strings.isNullOrEmpty((String)redoSql)) {
            return null;
        }
        Matcher m = SQL_PATTERN.matcher(redoSql.trim());
        if (!m.matches()) {
            throw new DebeziumException("Unable to parse unsupported LOB_WRITE SQL: " + redoSql);
        }
        String data = m.group(1);
        if (data.startsWith("'")) {
            data = data.substring(1, data.length() - 1);
        }
        int length = Integer.parseInt(m.group(2));
        int offset = Integer.parseInt(m.group(3)) - 1;
        if (data.contains("''")) {
            data = data.replaceAll("''", "'");
        }
        return new LobWrite(offset, length, data);
    }

    public record LobWrite(int offset, int length, String data) {
    }
}

