/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.connector.oracle.logminer.parser.AbstractSingleColumnSqlRedoPreambleParser;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.ParserUtils;
import io.debezium.relational.Table;

public class ExtendedStringParser
extends AbstractSingleColumnSqlRedoPreambleParser {
    private static final String STMT_PREFIX = " Stmt := '";
    private static final String STMT_SUFFIX = "';";
    private static final String UPDATE = "update ";
    private static final String SET = " set ";

    @Override
    protected void parseInternal(String sql, Table table) {
        sql = sql.trim();
        int startIndex = 0;
        ExtendedStringParser.startsWithAtIndexThrow("DECLARE", startIndex, sql);
        startIndex = ExtendedStringParser.indexOfThrow("BEGIN", sql, startIndex);
        startIndex = ExtendedStringParser.indexOfThrow(STMT_PREFIX, sql, startIndex);
        startIndex += STMT_PREFIX.length();
        if (!sql.endsWith(STMT_SUFFIX)) {
            throw new IllegalStateException("Expected 32K_BEGIN to end with \"';\": '" + sql + "'");
        }
        startIndex = 0;
        String update = sql.substring(startIndex, sql.length() - STMT_SUFFIX.length()).replace("''", "'");
        if (ExtendedStringParser.startsWithAtIndexThrow(UPDATE, startIndex, update)) {
            startIndex += UPDATE.length();
        }
        startIndex = ExtendedStringParser.parseQuotedValue(update, startIndex, value -> {
            this.tableName = value;
        });
        if (ExtendedStringParser.startsWithAtIndexThrow(SET, startIndex = ExtendedStringParser.parseQuotedValue(update, startIndex, value -> {
            this.schemaName = value;
        }), update)) {
            startIndex += SET.length();
        }
        if (ExtendedStringParser.startsWithAtIndexThrow(" = ", startIndex = ExtendedStringParser.parseQuotedValue(update, startIndex, value -> {
            this.columnName = value;
        }), update)) {
            startIndex += 3;
        }
        if (ExtendedStringParser.startsWithAtIndexThrow(":", startIndex, update) && ExtendedStringParser.startsWithAtIndexThrow(" ", startIndex = update.indexOf(" ", startIndex), update)) {
            ++startIndex;
        }
        if (ExtendedStringParser.startsWithAtIndexThrow("where ", startIndex, update)) {
            startIndex += "where ".length();
        }
        this.parseWhereClause(update, startIndex, table);
        ParserUtils.setColumnUnavailableValues(this.columnValues, table);
    }

    @Override
    protected LogMinerDmlEntry createDmlEntryForColumnValues(Object[] columnValues) {
        return LogMinerDmlEntryImpl.forExtendedString(columnValues);
    }
}

