/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.events;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Objects;

public class LogMinerEvent {
    private final EventType eventType;
    private final Scn scn;
    private final TableId tableId;
    private final String rowId;
    private final String rsId;
    private final Instant changeTime;
    private String transactionId;
    private Long transactionSequence;

    public LogMinerEvent(LogMinerEventRow row) {
        this(row.getEventType(), row.getScn(), row.getTableId(), row.getRowId(), row.getRsId(), row.getChangeTime());
        this.transactionId = row.getTransactionId();
        this.transactionSequence = row.getTransactionSequence();
    }

    public LogMinerEvent(EventType eventType, Scn scn, TableId tableId, String rowId, String rsId, Instant changeTime) {
        this.eventType = eventType;
        this.scn = scn;
        this.tableId = tableId;
        this.rowId = rowId;
        this.rsId = rsId;
        this.changeTime = changeTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Scn getScn() {
        return this.scn;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getRsId() {
        return this.rsId;
    }

    public Instant getChangeTime() {
        return this.changeTime;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Long getTransactionSequence() {
        return this.transactionSequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogMinerEvent that = (LogMinerEvent)o;
        return this.eventType == that.eventType && Objects.equals(this.scn, that.scn) && Objects.equals(this.tableId, that.tableId) && Objects.equals(this.rowId, that.rowId) && Objects.equals(this.rsId, that.rsId) && Objects.equals(this.changeTime, that.changeTime) && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.transactionSequence, that.transactionSequence);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.scn, this.tableId, this.rowId, this.rsId, this.changeTime, this.transactionId, this.transactionSequence});
    }

    public String toString() {
        return "LogMinerEvent{eventType=" + String.valueOf((Object)this.eventType) + ", scn=" + String.valueOf(this.scn) + ", tableId=" + String.valueOf(this.tableId) + ", rowId='" + this.rowId + "', rsId=" + this.rsId + ", changeTime=" + String.valueOf(this.changeTime) + ", transactionId=" + this.transactionId + ", transactionSequence=" + this.transactionSequence + "}";
    }
}

