/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.infinispan;

import io.debezium.DebeziumException;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.buffered.AbstractCacheProvider;
import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanLogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanTransaction;
import io.debezium.connector.oracle.logminer.buffered.infinispan.marshalling.LogMinerEventMarshallerImpl;
import io.debezium.connector.oracle.logminer.buffered.infinispan.marshalling.TransactionMarshallerImpl;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInfinispanCacheProvider
extends AbstractCacheProvider<InfinispanTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInfinispanCacheProvider.class);
    private static final String HOTROD_CLIENT_LOOKUP_PREFIX = "log.mining.buffer.infinispan.client.";
    private static final String HOTROD_CLIENT_PREFIX = "infinispan.client.";
    public static final String HOTROD_SERVER_LIST = "log.mining.buffer.infinispan.client.hotrod.server_list";
    private final boolean dropBufferOnStop;
    private final RemoteCacheManager cacheManager;
    private final LogMinerTransactionCache<InfinispanTransaction> transactionCache;
    private final InfinispanLogMinerCache<String, String> processedTransactionsCache;
    private final InfinispanLogMinerCache<String, String> schemaChangesCache;

    public RemoteInfinispanCacheProvider(OracleConnectorConfig connectorConfig) {
        LOGGER.info("Using Infinispan in Hotrod client mode to buffer transactions");
        this.dropBufferOnStop = connectorConfig.isLogMiningBufferDropOnStop();
        this.cacheManager = new RemoteCacheManager(RemoteInfinispanCacheProvider.createClientConfig(connectorConfig), true);
        this.transactionCache = this.createTransactionCache(connectorConfig);
        this.processedTransactionsCache = this.createProcessedTransactionCache(connectorConfig);
        this.schemaChangesCache = this.createSchemaChangesCache(connectorConfig);
        this.displayCacheStatistics();
    }

    @Override
    public LogMinerTransactionCache<InfinispanTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
        if (this.dropBufferOnStop) {
            LOGGER.info("Clearing infinispan caches");
            this.transactionCache.clear();
            this.schemaChangesCache.clear();
            this.processedTransactionsCache.clear();
            this.cacheManager.administration().removeCache("transactions");
            this.cacheManager.administration().removeCache("processed-transactions");
            this.cacheManager.administration().removeCache("schema-changes");
            this.cacheManager.administration().removeCache("events");
        }
        LOGGER.info("Shutting down infinispan remote caches");
        this.cacheManager.close();
    }

    private <C, V> RemoteCache<C, V> createCache(String cacheName, OracleConnectorConfig connectorConfig, Field field) {
        Objects.requireNonNull(cacheName);
        RemoteCache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            LOGGER.info("Remote cache '{}' already defined.", (Object)cacheName);
            return cache;
        }
        String cacheConfiguration = connectorConfig.getConfig().getString(field);
        Objects.requireNonNull(cacheConfiguration);
        cache = this.cacheManager.administration().createCache(cacheName, (BasicConfiguration)new StringConfiguration(cacheConfiguration));
        if (cache == null) {
            throw new DebeziumException("Failed to create remote Infinispan cache: " + cacheName);
        }
        LOGGER.info("Created remote infinispan cache: {}", (Object)cacheName);
        return cache;
    }

    private InfinispanLogMinerTransactionCache createTransactionCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerTransactionCache((BasicCache<String, InfinispanTransaction>)this.createCache("transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS), (BasicCache<String, LogMinerEvent>)this.createCache("events", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS));
    }

    private InfinispanLogMinerCache<String, String> createProcessedTransactionCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerCache<String, String>((BasicCache<String, String>)this.createCache("processed-transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS));
    }

    private InfinispanLogMinerCache<String, String> createSchemaChangesCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerCache<String, String>((BasicCache<String, String>)this.createCache("schema-changes", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES));
    }

    private static Configuration createClientConfig(OracleConnectorConfig connectorConfig) {
        return new ConfigurationBuilder().withProperties(RemoteInfinispanCacheProvider.getHotrodClientProperties(connectorConfig)).addContextInitializer(TransactionMarshallerImpl.class.getName()).addContextInitializer(LogMinerEventMarshallerImpl.class.getName()).build();
    }

    private static Properties getHotrodClientProperties(OracleConnectorConfig connectorConfig) {
        Map clientSettings = connectorConfig.getConfig().subset(HOTROD_CLIENT_LOOKUP_PREFIX, true).asMap();
        Properties properties = new Properties();
        for (Map.Entry entry : clientSettings.entrySet()) {
            properties.put(HOTROD_CLIENT_PREFIX + (String)entry.getKey(), entry.getValue());
            if (!((String)entry.getKey()).toLowerCase().endsWith("infinispan.client.hotrod.auth_username".toLowerCase())) continue;
            properties.put("infinispan.client.hotrod.use_auth", "true");
        }
        return properties;
    }
}

