/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.infinispan;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.buffered.AbstractTransaction;
import java.time.Instant;

public class InfinispanTransaction
extends AbstractTransaction {
    private int numberOfEvents;

    public InfinispanTransaction(String transactionId, Scn startScn, Instant changeTime, String userName, Integer redoThreadId, String clientId) {
        super(transactionId, startScn, changeTime, userName, redoThreadId, clientId);
        this.start();
    }

    public InfinispanTransaction(String transactionId, Scn startScn, Instant changeTime, String userName, int numberOfEvents, Integer redoThreadId, String clientId) {
        this(transactionId, startScn, changeTime, userName, redoThreadId, clientId);
        this.numberOfEvents = numberOfEvents;
    }

    @Override
    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    @Override
    public int getNextEventId() {
        return this.numberOfEvents++;
    }

    @Override
    public void start() {
        this.numberOfEvents = 0;
    }

    @Override
    public String getEventId(int index) {
        if (index < 0 || index >= this.numberOfEvents) {
            throw new IndexOutOfBoundsException("Index " + index + "outside the transaction " + this.getTransactionId() + " event list bounds");
        }
        return this.getTransactionId() + "-" + index;
    }

    @Override
    public String toString() {
        return "InfinispanTransaction{numberOfEvents=" + this.numberOfEvents + "} " + super.toString();
    }
}

