/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.infinispan;

import io.debezium.connector.oracle.logminer.buffered.AbstractLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanTransaction;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commons.api.BasicCache;

public class InfinispanLogMinerTransactionCache
extends AbstractLogMinerTransactionCache<InfinispanTransaction> {
    private final BasicCache<String, InfinispanTransaction> transactionCache;
    private final BasicCache<String, LogMinerEvent> eventCache;
    private final Map<String, TreeSet<Integer>> eventIdsByTransactionId = new HashMap<String, TreeSet<Integer>>();

    public InfinispanLogMinerTransactionCache(BasicCache<String, InfinispanTransaction> transactionCache, BasicCache<String, LogMinerEvent> eventCache) {
        this.transactionCache = transactionCache;
        this.eventCache = eventCache;
        this.primeHeapCacheFromOffHeapCaches();
    }

    @Override
    public InfinispanTransaction getTransaction(String transactionId) {
        return (InfinispanTransaction)this.transactionCache.get((Object)transactionId);
    }

    @Override
    public void addTransaction(InfinispanTransaction transaction) {
        this.transactionCache.put((Object)transaction.getTransactionId(), (Object)transaction);
        this.eventIdsByTransactionId.put(transaction.getTransactionId(), new TreeSet());
    }

    @Override
    public void removeTransaction(InfinispanTransaction transaction) {
        this.transactionCache.remove((Object)transaction.getTransactionId());
    }

    @Override
    public boolean containsTransaction(String transactionId) {
        return this.eventIdsByTransactionId.containsKey(transactionId);
    }

    @Override
    public boolean isEmpty() {
        return this.eventIdsByTransactionId.isEmpty();
    }

    @Override
    public int getTransactionCount() {
        return this.eventIdsByTransactionId.size();
    }

    @Override
    public <R> R streamTransactionsAndReturn(Function<Stream<InfinispanTransaction>, R> consumer) {
        try (Stream stream = this.transactionCache.values().stream();){
            R r = consumer.apply(stream);
            return r;
        }
    }

    @Override
    public void transactions(Consumer<Stream<InfinispanTransaction>> consumer) {
        try (Stream stream = this.transactionCache.values().stream();){
            consumer.accept(stream);
        }
    }

    @Override
    public void eventKeys(Consumer<Stream<String>> consumer) {
        try (Stream stream = this.eventCache.keySet().stream();){
            consumer.accept(stream);
        }
    }

    @Override
    public void forEachEvent(InfinispanTransaction transaction, LogMinerTransactionCache.InterruptiblePredicate<LogMinerEvent> predicate) throws InterruptedException {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            try (Stream stream = events.stream();){
                Iterator iterator = stream.iterator();
                while (iterator.hasNext()) {
                    LogMinerEvent event = this.getTransactionEvent(transaction, (int)((Integer)iterator.next()));
                    if (predicate.test(event)) continue;
                    break;
                }
            }
        }
    }

    @Override
    public LogMinerEvent getTransactionEvent(InfinispanTransaction transaction, int eventKey) {
        return (LogMinerEvent)this.eventCache.get((Object)transaction.getEventId(eventKey));
    }

    @Override
    public InfinispanTransaction getAndRemoveTransaction(String transactionId) {
        return (InfinispanTransaction)this.transactionCache.remove((Object)transactionId);
    }

    @Override
    public void addTransactionEvent(InfinispanTransaction transaction, int eventKey, LogMinerEvent event) {
        this.eventCache.put((Object)transaction.getEventId(eventKey), (Object)event);
        this.eventIdsByTransactionId.get(transaction.getTransactionId()).add(eventKey);
    }

    @Override
    public void removeTransactionEvents(InfinispanTransaction transaction) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            events.descendingSet().stream().map(transaction::getEventId).forEach(arg_0 -> this.eventCache.remove(arg_0));
        }
        this.eventIdsByTransactionId.remove(transaction.getTransactionId());
    }

    @Override
    public boolean removeTransactionEventWithRowId(InfinispanTransaction transaction, String rowId) {
        TreeSet<Integer> eventIds = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        for (Integer eventId : eventIds.descendingSet()) {
            String eventKey = transaction.getEventId(eventId);
            LogMinerEvent event = (LogMinerEvent)this.eventCache.get((Object)eventKey);
            if (event == null || !event.getRowId().equals(rowId)) continue;
            this.eventCache.remove((Object)eventKey);
            eventIds.remove(eventId);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTransactionEvent(InfinispanTransaction transaction, int eventKey) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            return events.contains(eventKey);
        }
        return false;
    }

    @Override
    public int getTransactionEventCount(InfinispanTransaction transaction) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            return events.size();
        }
        return 0;
    }

    @Override
    public int getTransactionEvents() {
        return this.eventIdsByTransactionId.values().stream().mapToInt(Set::size).sum();
    }

    @Override
    public void clear() {
        this.transactionCache.clear();
        this.eventCache.clear();
        this.eventIdsByTransactionId.clear();
    }

    @Override
    public void resetTransactionToStart(InfinispanTransaction transaction) {
        super.resetTransactionToStart(transaction);
        this.syncTransaction(transaction);
    }

    @Override
    public void syncTransaction(InfinispanTransaction transaction) {
        this.transactionCache.put((Object)transaction.getTransactionId(), (Object)transaction);
    }

    private void primeHeapCacheFromOffHeapCaches() {
        this.eventKeys(keyStream -> keyStream.map(k -> k.split("-", 2)).filter(parts -> ((String[])parts).length == 2).forEach(parts -> {
            String transactionId = parts[0];
            int eventId = Integer.parseInt(parts[1]);
            if (this.transactionCache.containsKey((Object)transactionId)) {
                this.eventIdsByTransactionId.computeIfAbsent(transactionId, k -> new TreeSet()).add(eventId);
            }
        }));
    }
}

