/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache.serialization;

import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.DeserializationContext;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.LogMinerEventSerdesProvider;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.SerializerInputStream;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.SerializerOutputStream;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import java.io.IOException;

public class DmlEventSerdesProvider<T extends DmlEvent>
extends LogMinerEventSerdesProvider<T> {
    @Override
    public Class<?> getJavaType() {
        return DmlEvent.class;
    }

    @Override
    public void serialize(DmlEvent event, SerializerOutputStream stream) throws IOException {
        super.serialize(event, stream);
        LogMinerDmlEntry dmlEntry = event.getDmlEntry();
        stream.writeInt(dmlEntry.getEventType().getValue());
        stream.writeString(dmlEntry.getObjectName());
        stream.writeString(dmlEntry.getObjectOwner());
        stream.writeObjectArray(dmlEntry.getNewValues());
        stream.writeObjectArray(dmlEntry.getOldValues());
    }

    @Override
    public void deserialize(DeserializationContext context, SerializerInputStream stream) throws IOException {
        super.deserialize(context, stream);
        int entryType = stream.readInt();
        String objectName = stream.readString();
        String objectOwner = stream.readString();
        Object[] newValues = stream.readObjectArray();
        Object[] oldValues = stream.readObjectArray();
        context.addValue(new LogMinerDmlEntryImpl(entryType, newValues, oldValues, objectOwner, objectName));
    }
}

