/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.buffered.AbstractCacheProvider;
import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheEvictionListener;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheLogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheTransaction;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EhcacheCacheProvider
extends AbstractCacheProvider<EhcacheTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheCacheProvider.class);
    private final boolean dropBufferOnStop;
    private final CacheManager cacheManager;
    private final EhcacheLogMinerTransactionCache transactionCache;
    private final EhcacheLogMinerCache<String, String> processedTransactionsCache;
    private final EhcacheLogMinerCache<String, String> schemaChangesCache;

    public EhcacheCacheProvider(OracleConnectorConfig connectorConfig) {
        LOGGER.info("Using Ehcache provider to buffer transactions");
        this.dropBufferOnStop = connectorConfig.isLogMiningBufferDropOnStop();
        this.cacheManager = this.createCacheManager(connectorConfig);
        EhcacheEvictionListener evictionListener = new EhcacheEvictionListener();
        this.transactionCache = this.createTransactionCache(evictionListener);
        this.processedTransactionsCache = this.createProcessedTransactionCache(evictionListener);
        this.schemaChangesCache = this.createSchemaChangesCache(evictionListener);
    }

    @Override
    public LogMinerTransactionCache<EhcacheTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
        if (this.cacheManager != null) {
            if (this.dropBufferOnStop) {
                LOGGER.info("Clearing Ehcache caches");
                this.transactionCache.clear();
                this.schemaChangesCache.clear();
                this.processedTransactionsCache.clear();
                this.cacheManager.removeCache("transactions");
                this.cacheManager.removeCache("processed-transactions");
                this.cacheManager.removeCache("schema-changes");
                this.cacheManager.removeCache("events");
            }
            LOGGER.info("Shutting down Ehcache embedded caches");
            this.cacheManager.close();
        }
    }

    private CacheManager createCacheManager(OracleConnectorConfig connectorConfig) {
        try {
            Configuration ehcacheConfig = connectorConfig.getLogMiningEhcacheConfiguration();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            String xmlData = this.getConfigurationWithSubstitutions(ehcacheConfig);
            LOGGER.debug("Using Ehcache XML configuration:\n{}", (Object)xmlData);
            Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlData)));
            CacheManager cacheManager = CacheManagerBuilder.newCacheManager((org.ehcache.config.Configuration)new XmlConfiguration(xmlDocument));
            cacheManager.init();
            return cacheManager;
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to create Ehcache cache manager", (Throwable)e);
        }
    }

    private String getConfigurationWithSubstitutions(Configuration configuration) {
        return this.readConfigurationTemplate().replace("${log.mining.buffer.ehcache.global.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_GLOBAL_CONFIG, "")).replace("${log.mining.buffer.ehcache.transactions.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_TRANSACTIONS_CONFIG, "")).replace("${log.mining.buffer.ehcache.processedtransactions.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_PROCESSED_TRANSACTIONS_CONFIG, "")).replace("${log.mining.buffer.ehcache.schemachanges.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_SCHEMA_CHANGES_CONFIG, "")).replace("${log.mining.buffer.ehcache.events.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_EVENTS_CONFIG, ""));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readConfigurationTemplate() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("ehcache/configuration-template.xml");){
            String string;
            if (inputStream == null) {
                throw new DebeziumException("Failed to find ehcache/configuration-template.xml");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to read Ehcache configuration template", (Throwable)e);
        }
    }

    private <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType, EhcacheEvictionListener listener) {
        Cache cache = this.cacheManager.getCache(cacheName, keyType, valueType);
        cache.getRuntimeConfiguration().registerCacheEventListener((CacheEventListener)listener, EventOrdering.ORDERED, EventFiring.SYNCHRONOUS, Set.of(EventType.EVICTED));
        return cache;
    }

    private EhcacheLogMinerTransactionCache createTransactionCache(EhcacheEvictionListener evictionListener) {
        return new EhcacheLogMinerTransactionCache(this.getCache("transactions", String.class, EhcacheTransaction.class, evictionListener), this.getCache("events", String.class, LogMinerEvent.class, evictionListener), evictionListener);
    }

    private EhcacheLogMinerCache<String, String> createProcessedTransactionCache(EhcacheEvictionListener evictionListener) {
        return new EhcacheLogMinerCache<String, String>(this.getCache("processed-transactions", String.class, String.class, evictionListener), "processed-transactions", evictionListener);
    }

    private EhcacheLogMinerCache<String, String> createSchemaChangesCache(EhcacheEvictionListener evictionListener) {
        return new EhcacheLogMinerCache<String, String>(this.getCache("schema-changes", String.class, String.class, evictionListener), "schema-changes", evictionListener);
    }
}

