/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import java.util.ArrayList;
import java.util.List;

public class UnistrHelper {
    private static final String UNITSTR_FUNCTION_START = "UNISTR('";
    private static final String UNISTR_FUNCTION_END = "')";

    public static boolean isUnistrFunction(String data) {
        return data != null && data.startsWith(UNITSTR_FUNCTION_START) && data.endsWith(UNISTR_FUNCTION_END);
    }

    public static String convert(String data) {
        if (data == null || data.length() == 0) {
            return data;
        }
        if (data.contains("''")) {
            data = data.replaceAll("''", "'");
        }
        List<String> parts = UnistrHelper.tokenize(data);
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            String trimmedPart = part.trim();
            if (UnistrHelper.isUnistrFunction(trimmedPart)) {
                result.append(UnistrHelper.decode(trimmedPart.substring(8, trimmedPart.length() - 2)));
                continue;
            }
            result.append(data);
        }
        return result.toString();
    }

    private static String decode(String value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' && value.length() >= i + 4) {
                result.append(Character.toChars(Integer.parseInt(value.substring(i + 1, i + 5), 16)));
                i += 4;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static List<String> tokenize(String data) {
        ArrayList<String> parts = new ArrayList<String>();
        int length = data.length();
        boolean inQuotedData = false;
        int startIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (UnistrHelper.stringMatches(data, i, UNITSTR_FUNCTION_START)) {
                inQuotedData = true;
                if (startIndex != -1) continue;
                startIndex = i;
                continue;
            }
            if (inQuotedData && UnistrHelper.stringMatches(data, i, UNISTR_FUNCTION_END)) {
                inQuotedData = false;
                continue;
            }
            if (inQuotedData || !UnistrHelper.stringMatches(data, i, "||")) continue;
            parts.add(data.substring(startIndex, i).trim());
            startIndex = ++i + 1;
        }
        if (startIndex < data.length()) {
            parts.add(data.substring(startIndex).trim());
        }
        return parts;
    }

    private static boolean stringMatches(String str, int index, String token) {
        return str.regionMatches(index, token, 0, token.length());
    }
}

