/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.Scn;
import java.math.BigInteger;
import java.util.Objects;

public class LogFile {
    private final String fileName;
    private final Scn firstScn;
    private final Scn nextScn;
    private final BigInteger sequence;
    private final boolean current;
    private final Type type;
    private final int thread;

    public LogFile(String fileName, Scn firstScn, Scn nextScn, BigInteger sequence, Type type, int thread) {
        this(fileName, firstScn, nextScn, sequence, type, false, thread);
    }

    public LogFile(String fileName, Scn firstScn, Scn nextScn, BigInteger sequence, Type type, boolean current, int thread) {
        this.fileName = fileName;
        this.firstScn = firstScn;
        this.nextScn = nextScn;
        this.sequence = sequence;
        this.current = current;
        this.type = type;
        this.thread = thread;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Scn getFirstScn() {
        return this.firstScn;
    }

    public Scn getNextScn() {
        return this.isCurrent() ? Scn.MAX : this.nextScn;
    }

    public BigInteger getSequence() {
        return this.sequence;
    }

    public int getThread() {
        return this.thread;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isScnInLogFileRange(Scn scn) {
        return this.getFirstScn().compareTo(scn) <= 0 && (this.getNextScn().compareTo(scn) > 0 || this.getNextScn().equals(Scn.MAX));
    }

    public boolean isArchive() {
        return this.type == Type.ARCHIVE;
    }

    public boolean isRedo() {
        return this.type == Type.REDO;
    }

    public int hashCode() {
        return Objects.hash(this.thread, this.sequence);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogFile)) {
            return false;
        }
        LogFile other = (LogFile)obj;
        return this.thread == other.thread && Objects.equals(this.sequence, other.sequence);
    }

    public String toString() {
        return "LogFile{fileName='" + this.fileName + "', firstScn=" + String.valueOf(this.firstScn) + ", nextScn=" + String.valueOf(this.nextScn) + ", sequence=" + String.valueOf(this.sequence) + ", current=" + this.current + ", type=" + String.valueOf((Object)this.type) + ", thread=" + this.thread + "}";
    }

    public static enum Type {
        ARCHIVE,
        REDO;

    }
}

