/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.RedoThreadState;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogFileCollector;
import io.debezium.connector.oracle.logminer.LogFileNotFoundException;
import io.debezium.connector.oracle.logminer.LogMinerDatabaseStateWriter;
import io.debezium.connector.oracle.logminer.LogMinerSessionContext;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.OffsetActivityMonitor;
import io.debezium.connector.oracle.logminer.RetriableLogMinerException;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.ExtendedStringBeginEvent;
import io.debezium.connector.oracle.logminer.events.ExtendedStringWriteEvent;
import io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.events.RedoSqlDmlEvent;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.connector.oracle.logminer.events.XmlBeginEvent;
import io.debezium.connector.oracle.logminer.events.XmlEndEvent;
import io.debezium.connector.oracle.logminer.events.XmlWriteEvent;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.ExtendedStringParser;
import io.debezium.connector.oracle.logminer.parser.LobWriteParser;
import io.debezium.connector.oracle.logminer.parser.LogMinerColumnResolverDmlParser;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import io.debezium.connector.oracle.logminer.parser.XmlBeginParser;
import io.debezium.connector.oracle.logminer.parser.XmlWriteParser;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.text.ParsingException;
import io.debezium.util.Clock;
import io.debezium.util.Loggings;
import io.debezium.util.Metronome;
import io.debezium.util.Stopwatch;
import io.debezium.util.Strings;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogMinerStreamingChangeEventSource
implements StreamingChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogMinerStreamingChangeEventSource.class);
    private static final String NO_REDO_SQL_FOR_TEMPORARY_TABLES = "/* No SQL_REDO for temporary tables */";
    private static final int MINING_START_RETRIES = 5;
    private static final int MAXIMUM_NAME_LENGTH = 30;
    private static final int MAX_ITERATIONS_BEFORE_OFFSET_STALE = 25;
    private static final Long SMALL_REDO_LOG_WARNING = 524288000L;
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final LogMinerStreamingChangeEventSourceMetrics metrics;
    private final JdbcConfiguration jdbcConfiguration;
    private final boolean useContinuousMining;
    private final LogFileCollector logCollector;
    private final LogMinerSessionContext sessionContext;
    private final LogMinerDmlParser dmlParser;
    private final LogMinerColumnResolverDmlParser reconstructColumnDmlParser;
    private final SelectLobParser selectLobParser;
    private final ExtendedStringParser extendedStringParser;
    private final XmlBeginParser xmlBeginParser;
    private final Tables.TableFilter tableFilter;
    private final String archiveDestinationName;
    private boolean sequenceUnavailable = false;
    private List<LogFile> currentLogFiles;
    private List<BigInteger> currentRedoLogSequences;
    private OracleOffsetContext effectiveOffset;
    private OraclePartition partition;
    private ChangeEventSource.ChangeEventSourceContext context;
    private int currentBatchSize;
    private long currentSleepTime;
    private OffsetActivityMonitor offsetActivityMonitor;

    public AbstractLogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, LogMinerStreamingChangeEventSourceMetrics metrics) {
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.metrics = metrics;
        this.jdbcConfiguration = JdbcConfiguration.adapt((Configuration)jdbcConfig);
        this.useContinuousMining = connectorConfig.isLogMiningContinuousMining(jdbcConnection.getOracleVersion());
        this.logCollector = new LogFileCollector(connectorConfig, jdbcConnection);
        this.sessionContext = new LogMinerSessionContext(jdbcConnection, this.useContinuousMining, connectorConfig.getLogMiningStrategy(), connectorConfig.getLogMiningPathToDictionary());
        this.dmlParser = new LogMinerDmlParser(connectorConfig);
        this.reconstructColumnDmlParser = new LogMinerColumnResolverDmlParser(connectorConfig);
        this.selectLobParser = new SelectLobParser();
        this.extendedStringParser = new ExtendedStringParser();
        this.xmlBeginParser = new XmlBeginParser();
        this.tableFilter = connectorConfig.getTableFilters().dataCollectionFilter();
        this.archiveDestinationName = connectorConfig.getArchiveDestinationNameResolver().getDestinationName(jdbcConnection);
        metrics.setBatchSize(connectorConfig.getLogMiningBatchSizeDefault());
        metrics.setSleepTime(connectorConfig.getLogMiningSleepTimeDefault().toMillis());
    }

    public void init(OracleOffsetContext offsetContext) throws InterruptedException {
        this.effectiveOffset = offsetContext == null ? this.emptyContext() : offsetContext;
    }

    public OracleOffsetContext getOffsetContext() {
        return this.effectiveOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) throws InterruptedException {
        try {
            this.effectiveOffset = offsetContext;
            this.partition = partition;
            this.context = context;
            this.offsetActivityMonitor = new OffsetActivityMonitor(25, this.getOffsetContext(), this.getMetrics());
            this.prepareJdbcConnection(false);
            this.checkDatabaseAndTableState();
            this.logOnlineRedoLogSizes();
            Scn offsetScn = this.getOffsetContext().getScn();
            Scn snapshotScn = this.getOffsetContext().getSnapshotScn();
            Scn firstScn = this.getFirstScnAvailableInLogs();
            if (offsetScn.compareTo(snapshotScn) == 0) {
                Scn startScn = this.computeStartScnForFirstMiningSession(firstScn, offsetScn, snapshotScn);
                this.getOffsetContext().setScn(startScn);
            }
            if (!this.useContinuousMining && offsetScn.compareTo(firstScn.subtract(Scn.ONE)) < 0) {
                throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + String.valueOf(offsetScn) + ". Please perform a new snapshot.");
            }
            if (this.isArchiveLogOnlyModeAndScnIsNotAvailable(this.getOffsetContext().getScn())) {
                return;
            }
            this.executeLogMiningStreaming();
        }
        catch (Throwable throwable) {
            LOGGER.error("LogMiner session stopped due to an error.", throwable);
            this.metrics.incrementErrorCount();
            this.errorHandler.setProducerThrowable(throwable);
        }
        finally {
            LOGGER.info("Streaming metrics at shutdown: {}", (Object)this.metrics);
            LOGGER.info("Offsets as shutdown: {}", (Object)offsetContext);
        }
    }

    protected abstract void executeLogMiningStreaming() throws Exception;

    protected abstract void enqueueEvent(LogMinerEventRow var1, LogMinerEvent var2) throws InterruptedException;

    protected abstract void handleTruncateEvent(LogMinerEventRow var1) throws InterruptedException;

    protected ChangeEventSource.ChangeEventSourceContext getContext() {
        return this.context;
    }

    protected LogMinerSessionContext getLogMinerContext() {
        return this.sessionContext;
    }

    protected OraclePartition getPartition() {
        return this.partition;
    }

    protected EventDispatcher<OraclePartition, TableId> getEventDispatcher() {
        return this.dispatcher;
    }

    protected OracleDatabaseSchema getSchema() {
        return this.schema;
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected OracleConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected JdbcConfiguration getJdbcConfiguration() {
        return this.jdbcConfiguration;
    }

    protected OracleConnection getConnection() {
        return this.jdbcConnection;
    }

    protected LogMinerStreamingChangeEventSourceMetrics getMetrics() {
        return this.metrics;
    }

    protected LogMinerStreamingChangeEventSourceMetrics.BatchMetrics getBatchMetrics() {
        return this.metrics.getBatchMetrics();
    }

    protected boolean isUsingPluggableDatabase() {
        return !Strings.isNullOrBlank((String)this.connectorConfig.getPdbName());
    }

    protected boolean isUsingCatalogInRedoStrategy() {
        return OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.connectorConfig.getLogMiningStrategy());
    }

    protected boolean isUsingHybridStrategy() {
        return OracleConnectorConfig.LogMiningStrategy.HYBRID.equals((Object)this.connectorConfig.getLogMiningStrategy());
    }

    protected boolean isUsingCommittedDataOnly() {
        return false;
    }

    protected List<LogFile> getCurrentLogFiles() {
        return this.currentLogFiles;
    }

    protected OffsetActivityMonitor getOffsetActivityMonitor() {
        return this.offsetActivityMonitor;
    }

    protected void executeBlockingSnapshot() throws InterruptedException {
        LOGGER.info("Streaming will now pause");
        this.context.streamingPaused();
        this.context.waitSnapshotCompletion();
        LOGGER.info("Streaming resumed");
    }

    protected boolean hasNextWithMetricsUpdate(ResultSet resultSet) throws SQLException {
        Instant start = Instant.now();
        boolean result = false;
        try {
            if (resultSet.next()) {
                this.getMetrics().setLastResultSetNextDuration(Duration.between(start, Instant.now()));
                result = true;
            }
            if (this.sequenceUnavailable) {
                LOGGER.debug("The previous batch's unavailable log problem has been cleared.");
                this.sequenceUnavailable = false;
            }
        }
        catch (SQLException e) {
            if (!e.getMessage().startsWith("ORA-00310")) {
                throw e;
            }
            if (this.sequenceUnavailable) {
                LOGGER.error("The log availability error '{}' wasn't cleared, stop requested.", (Object)e.getMessage());
                throw e;
            }
            LOGGER.debug("A mined log is no longer available: {}", (Object)e.getMessage());
            LOGGER.warn("Restarting mining session after a log became unavailable.");
            this.sequenceUnavailable = true;
        }
        return result;
    }

    protected void executeAndProcessQuery(PreparedStatement statement) throws SQLException, InterruptedException {
        Instant queryStartTime = Instant.now();
        try (ResultSet resultSet = statement.executeQuery();){
            this.getMetrics().setLastDurationOfFetchQuery(Duration.between(queryStartTime, Instant.now()));
            Instant startProcessTime = Instant.now();
            String catalogName = this.getConfig().getCatalogName();
            while (this.getContext().isRunning() && this.hasNextWithMetricsUpdate(resultSet)) {
                this.getBatchMetrics().rowObserved();
                LogMinerEventRow event = LogMinerEventRow.fromResultSet(resultSet, catalogName);
                this.processEvent(event);
            }
            this.getBatchMetrics().updateStreamingMetrics();
            if (this.getBatchMetrics().hasProcessedAnyTransactions()) {
                this.getOffsetActivityMonitor().checkForStaleOffsets();
            }
            LOGGER.debug("{}.", (Object)this.getBatchMetrics());
            LOGGER.debug("Processed in {} ms. Lag {}. Active Transactions: {}. Sleep: {}. Offsets: {}", new Object[]{Duration.between(startProcessTime, Instant.now()), this.getMetrics().getLagFromSourceInMilliseconds(), this.getMetrics().getNumberOfActiveTransactions(), this.getMetrics().getSleepTimeInMilliseconds(), this.getOffsetContext()});
        }
    }

    protected void executeDataChangeEventPreDispatchSteps(LogMinerEventRow event) throws InterruptedException {
    }

    protected boolean isDispatchAllowedForDataChangeEvent(LogMinerEventRow event) {
        return true;
    }

    protected boolean hasEventBeenProcessed(LogMinerEventRow event) {
        return false;
    }

    protected boolean isEventSkipped(LogMinerEventRow event) {
        return false;
    }

    protected void processEvent(LogMinerEventRow event) throws SQLException, InterruptedException {
        if (!this.hasEventBeenProcessed(event) && !this.isEventSkipped(event)) {
            this.preProcessEvent(event);
            switch (event.getEventType()) {
                case MISSING_SCN: {
                    this.handleMissingScnEvent(event);
                    break;
                }
                case START: {
                    this.handleStartEvent(event);
                    break;
                }
                case COMMIT: {
                    this.handleCommitEvent(event);
                    break;
                }
                case ROLLBACK: {
                    this.handleRollbackEvent(event);
                    break;
                }
                case DDL: {
                    this.handleSchemaChangeEvent(event);
                    break;
                }
                case INSERT: 
                case UPDATE: 
                case DELETE: {
                    this.handleDataChangeEvent(event);
                    break;
                }
                case REPLICATION_MARKER: {
                    this.handleReplicationMarkerEvent(event);
                    break;
                }
                case UNSUPPORTED: {
                    this.handleUnsupportedEvent(event);
                    break;
                }
                case SELECT_LOB_LOCATOR: {
                    this.handleSelectLobLocatorEvent(event);
                    break;
                }
                case LOB_WRITE: {
                    this.handleLobWriteEvent(event);
                    break;
                }
                case LOB_ERASE: {
                    this.handleLobEraseEvent(event);
                    break;
                }
                case XML_BEGIN: {
                    this.handleXmlBeginEvent(event);
                    break;
                }
                case XML_WRITE: {
                    this.handleXmlWriteEvent(event);
                    break;
                }
                case XML_END: {
                    this.handleXmlEndEvent(event);
                    break;
                }
                case EXTENDED_STRING_BEGIN: {
                    this.handleExtendedStringBeginEvent(event);
                    break;
                }
                case EXTENDED_STRING_WRITE: {
                    this.handleExtendedStringWriteEvent(event);
                    break;
                }
                case EXTENDED_STRING_END: {
                    this.handleExtendedStringEndEvent(event);
                    break;
                }
                default: {
                    Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Skipped event {}", (Object[])new Object[]{event.getEventType()});
                }
            }
        }
    }

    protected void preProcessEvent(LogMinerEventRow event) {
        this.getBatchMetrics().rowProcessed();
    }

    protected void handleMissingScnEvent(LogMinerEventRow event) {
        Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Event with `MISSING_SCN` operation found with SCN {}", (Object[])new Object[]{event.getScn()});
    }

    protected abstract void handleStartEvent(LogMinerEventRow var1) throws InterruptedException;

    protected abstract void handleCommitEvent(LogMinerEventRow var1) throws InterruptedException;

    protected abstract void handleRollbackEvent(LogMinerEventRow var1) throws InterruptedException;

    protected abstract void handleSchemaChangeEvent(LogMinerEventRow var1) throws InterruptedException;

    protected abstract void handleReplicationMarkerEvent(LogMinerEventRow var1) throws InterruptedException;

    protected void handleUnsupportedEvent(LogMinerEventRow event) {
        if (!Strings.isNullOrEmpty((String)event.getTableName())) {
            Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)event, (String)"An unsupported operation detected for table '{}' in transaction {} with SCN {} on redo thread {}.", (Object[])new Object[]{event.getTableId(), event.getTransactionId(), event.getScn(), event.getThread()});
        }
    }

    protected void handleDataChangeEvent(LogMinerEventRow event) throws SQLException, InterruptedException {
        if (Strings.isNullOrBlank((String)event.getRedoSql())) {
            LOGGER.trace("Data event in transaction {} with SCN {} has empty redo SQL: {}", new Object[]{event.getTransactionId(), event.getScn(), Loggings.maybeRedactSensitiveData((Object)event)});
            return;
        }
        Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"DML: {}", (Object[])new Object[]{event});
        if (event.hasErrorStatus() && !Strings.isNullOrBlank((String)event.getInfo()) && (!this.isUsingHybridStrategy() || this.isUsingHybridStrategy() && !this.isTableKnown(event.getTableId()))) {
            this.notifyEventProcessingFailure(event, null);
            return;
        }
        if (this.isNoSqlRedoForTemporaryTable(event)) {
            Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Skipped a change for a temporary table.", (Object[])new Object[0]);
            return;
        }
        this.getBatchMetrics().dataChangeEventObserved(event.getEventType());
        this.executeDataChangeEventPreDispatchSteps(event);
        Table table = this.getTableForDataEvent(event);
        if (table != null && this.isDispatchAllowedForDataChangeEvent(event)) {
            this.dispatchDataChangeEventInternal(event, table);
        }
    }

    protected void handleSelectLobLocatorEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table == null) {
                return;
            }
            LogMinerDmlEntry parsedEvent = this.selectLobParser.parse(event.getRedoSql(), table);
            parsedEvent.setObjectName(event.getTableName());
            parsedEvent.setObjectOwner(event.getTablespaceName());
            this.enqueueEvent(event, new SelectLobLocatorEvent(event, parsedEvent, this.selectLobParser.getColumnName(), this.selectLobParser.isBinary()));
            this.getMetrics().incrementTotalChangesCount();
        }
    }

    protected void handleLobWriteEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled() && !Strings.isNullOrEmpty((String)event.getRedoSql())) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table == null) {
                return;
            }
            LobWriteParser.LobWrite parsedEvent = LobWriteParser.parse(event.getRedoSql());
            if (parsedEvent != null) {
                this.enqueueEvent(event, new LobWriteEvent(event, parsedEvent));
            }
        }
    }

    protected void handleLobEraseEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table != null) {
                this.enqueueEvent(event, new LobEraseEvent(event));
            }
        }
    }

    protected void handleExtendedStringBeginEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table == null) {
                return;
            }
            LogMinerDmlEntry parsedEvent = this.extendedStringParser.parse(event.getRedoSql(), table);
            parsedEvent.setObjectName(event.getTableName());
            parsedEvent.setObjectOwner(event.getTablespaceName());
            this.enqueueEvent(event, new ExtendedStringBeginEvent(event, parsedEvent, this.extendedStringParser.getColumnName()));
            this.getMetrics().incrementTotalChangesCount();
        }
    }

    protected void handleExtendedStringWriteEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled() && !Strings.isNullOrEmpty((String)event.getRedoSql())) {
            String data;
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table == null) {
                return;
            }
            try {
                String sql = event.getRedoSql();
                int endIndex = sql.lastIndexOf(";");
                if (endIndex == -1) {
                    throw new DebeziumException("Failed to find end index on 32K_WRITE operation");
                }
                if ((endIndex = sql.lastIndexOf(";", endIndex - 1)) == -1) {
                    throw new DebeziumException("Failed to find end index on 32K_WRITE operation");
                }
                data = sql.substring(12, endIndex - 1);
            }
            catch (Exception e) {
                throw new ParsingException(null, "Failed to parse 32K_WRITE event", (Throwable)e);
            }
            this.enqueueEvent(event, new ExtendedStringWriteEvent(event, data));
        }
    }

    protected void handleExtendedStringEndEvent(LogMinerEventRow event) {
    }

    protected void handleXmlBeginEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table == null) {
                return;
            }
            LogMinerDmlEntry parsedEvent = this.xmlBeginParser.parse(event.getRedoSql(), table);
            parsedEvent.setObjectName(event.getTableName());
            parsedEvent.setObjectOwner(event.getTablespaceName());
            this.enqueueEvent(event, new XmlBeginEvent(event, parsedEvent, this.xmlBeginParser.getColumnName()));
        }
    }

    protected void handleXmlWriteEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table != null) {
                XmlWriteParser.XmlWrite parsedEvent = XmlWriteParser.parse(event.getRedoSql());
                this.enqueueEvent(event, new XmlWriteEvent(event, parsedEvent.data(), parsedEvent.length()));
            }
        }
    }

    protected void handleXmlEndEvent(LogMinerEventRow event) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            TableId tableId = event.getTableId();
            Table table = this.getSchema().tableFor(tableId);
            if (table != null) {
                this.enqueueEvent(event, new XmlEndEvent(event));
            }
        }
    }

    protected boolean waitForRangeAvailabilityInArchiveLogs(Scn startScn, Scn endScn) throws SQLException, InterruptedException {
        if (endScn.isNull()) {
            if (this.isArchiveLogOnlyModeAndScnIsNotAvailable(startScn)) {
                LOGGER.error("Could not find the start SCN {} in the archive logs, stopping connector.", (Object)startScn);
                return true;
            }
        } else if (this.isNoDataProcessedInBatchAndAtEndOfArchiveLogs() && endScn.compareTo(this.getMaximumArchiveLogsScn()) == 0) {
            return this.isArchiveLogOnlyModeAndScnIsNotAvailable(endScn.add(Scn.ONE));
        }
        return false;
    }

    protected abstract boolean isNoDataProcessedInBatchAndAtEndOfArchiveLogs();

    protected Scn calculateUpperBounds(Scn lowerBoundsScn, Scn previousUpperBounds, Scn currentScn) throws SQLException {
        Scn minOpenRedoThreadLastScn;
        Scn maximumScn = this.getConfig().isArchiveLogOnlyMode() ? this.getMaximumArchiveLogsScn() : currentScn;
        Scn maximumBatchScn = lowerBoundsScn.add(Scn.valueOf(this.metrics.getBatchSize()));
        Scn defaultBatchSizeScn = Scn.valueOf(this.connectorConfig.getLogMiningBatchSizeDefault());
        Scn maxBatchSizeScn = Scn.valueOf(this.connectorConfig.getLogMiningBatchSizeMax());
        Scn result = maximumBatchScn;
        boolean batchUpperBoundsScnAfterCurrentScn = false;
        if (maximumBatchScn.subtract(maximumScn).compareTo(defaultBatchSizeScn) > 0) {
            this.decrementBatchSize();
            batchUpperBoundsScnAfterCurrentScn = true;
        }
        if (maximumScn.subtract(maximumBatchScn).compareTo(defaultBatchSizeScn) > 0) {
            this.incrementBatchSize();
        }
        if (maximumScn.compareTo(maximumBatchScn) < 0) {
            if (!batchUpperBoundsScnAfterCurrentScn) {
                this.incrementSleepTime();
            }
            LOGGER.debug("Batch upper bounds {} exceeds maximum read position, capping to {}.", (Object)maximumBatchScn, (Object)maximumScn);
            result = maximumScn;
        } else if (!previousUpperBounds.isNull() && maximumBatchScn.compareTo(previousUpperBounds) <= 0) {
            Scn extendedUpperBounds = previousUpperBounds.add(maxBatchSizeScn);
            if (extendedUpperBounds.compareTo(maximumScn) > 0) {
                extendedUpperBounds = maximumScn;
            }
            LOGGER.debug("Batch size upper bounds {} too small, using maximum read position {} instead.", (Object)maximumBatchScn, (Object)extendedUpperBounds);
            result = extendedUpperBounds;
        } else {
            long deltaTime;
            Optional<Instant> upperBoundsScnTimestamp;
            Optional<Instant> prevEndScnTimestamp;
            Scn deltaScn;
            this.decrementSleepTime();
            if (maximumBatchScn.compareTo(lowerBoundsScn) < 0) {
                LOGGER.debug("Batch upper bounds {} is before start SCN {}, fallback to maximum read position {}.", new Object[]{maximumBatchScn, lowerBoundsScn, maximumScn});
                result = maximumScn;
            } else if (!previousUpperBounds.isNull() && (deltaScn = maximumScn.subtract(previousUpperBounds)).compareTo(Scn.valueOf(this.connectorConfig.getLogMiningScnGapDetectionGapSizeMin())) > 0 && (prevEndScnTimestamp = this.jdbcConnection.getScnToTimestamp(previousUpperBounds)).isPresent() && (upperBoundsScnTimestamp = this.jdbcConnection.getScnToTimestamp(maximumScn)).isPresent() && (deltaTime = ChronoUnit.MILLIS.between(prevEndScnTimestamp.get(), upperBoundsScnTimestamp.get())) < (long)this.connectorConfig.getLogMiningScnGapDetectionTimeIntervalMaxMs()) {
                LOGGER.debug("SCN delta {} is less than {} within a time window of {} milliseconds. This could indicate a high volume of changes or an unusual increase in the SCN over the time window. Using upperbounds SCN {} at timestamp {} (start SCN {}, previous end SCN {} at timestamp {}).", new Object[]{deltaScn, this.connectorConfig.getLogMiningScnGapDetectionGapSizeMin(), this.connectorConfig.getLogMiningScnGapDetectionTimeIntervalMaxMs(), maximumScn, upperBoundsScnTimestamp.get(), lowerBoundsScn, previousUpperBounds, prevEndScnTimestamp.get()});
                result = maximumScn;
            }
        }
        Duration deviation = this.connectorConfig.getLogMiningMaxScnDeviation();
        if (!deviation.isZero()) {
            Optional<Scn> deviatedScn = this.calculateDeviatedEndScn(lowerBoundsScn, result, deviation);
            if (deviatedScn.isEmpty()) {
                return Scn.NULL;
            }
            LOGGER.debug("Adjusted upper bounds {} based on deviation to {}.", (Object)result, (Object)deviatedScn.get());
            result = deviatedScn.get();
        }
        if (!(minOpenRedoThreadLastScn = this.jdbcConnection.getRedoThreadState().getThreads().stream().filter(RedoThreadState.RedoThread::isOpen).map(RedoThreadState.RedoThread::getLastRedoScn).min(Scn::compareTo).orElse(Scn.NULL)).isNull() && (minOpenRedoThreadLastScn = minOpenRedoThreadLastScn.subtract(Scn.valueOf(this.connectorConfig.getLogMiningRedoThreadScnAdjustment()))).compareTo(result) < 0) {
            if (minOpenRedoThreadLastScn.compareTo(lowerBoundsScn) < 0) {
                return Scn.NULL;
            }
            LOGGER.debug("Adjusting upper bounds {} to minimum read thread flush SCN {}.", (Object)result, (Object)minOpenRedoThreadLastScn);
            result = minOpenRedoThreadLastScn;
        }
        if (result.compareTo(lowerBoundsScn) <= 0) {
            LOGGER.debug("Final upper bounds {} matches start read position, delay required.", (Object)result);
            return Scn.NULL;
        }
        LOGGER.debug("Final upper bounds range is {}.", (Object)result);
        return result;
    }

    protected boolean isArchiveLogOnlyModeAndScnIsNotAvailable(Scn scn) throws SQLException, InterruptedException {
        return this.connectorConfig.isArchiveLogOnlyMode() && !this.waitForScnInArchiveLogs(scn);
    }

    protected void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.metrics.getSleepTimeInMilliseconds());
        Metronome.sleeper((Duration)period, (Clock)this.clock).pause();
    }

    protected void prepareJdbcConnection(boolean closeAndReconnect) throws SQLException {
        if (closeAndReconnect) {
            LOGGER.debug("Log switch or maximum session threshold detected, restarting Oracle JDBC connection.");
            this.jdbcConnection.close();
            if (this.isUsingPluggableDatabase()) {
                this.jdbcConnection.resetSessionToCdb();
            }
        }
        this.jdbcConnection.setAutoCommit(false);
        this.setNlsSessionParameters();
        this.setHashSortArea();
    }

    protected void updateDatabaseTimeDifference() throws SQLException {
        this.metrics.setDatabaseTimeDifference(this.jdbcConnection.getDatabaseSystemTime());
    }

    protected Scn getCurrentScn() throws SQLException {
        return this.jdbcConnection.getCurrentScn();
    }

    protected Scn getMaximumArchiveLogsScn() {
        List archiveLogs;
        List<Object> list = archiveLogs = this.currentLogFiles == null ? Collections.emptyList() : this.currentLogFiles.stream().filter(LogFile::isArchive).toList();
        if (archiveLogs.isEmpty()) {
            throw new DebeziumException("Cannot get maximum archive log SCN as no archive logs are present.");
        }
        Scn maximumScn = archiveLogs.stream().map(LogFile::getNextScn).max(Scn::compareTo).orElseThrow();
        LOGGER.debug("Maximum archive log SCN resolved as {}", (Object)maximumScn);
        return maximumScn;
    }

    protected boolean isMiningSessionRestartRequired(Stopwatch stopWatch) {
        Duration maximumSessionDuration = this.connectorConfig.getLogMiningMaximumSession().orElse(null);
        if (maximumSessionDuration != null) {
            Duration watchTime = stopWatch.stop().durations().statistics().getTotal();
            if (watchTime.compareTo(maximumSessionDuration) >= 0) {
                LOGGER.info("LogMiner session has exceeded maximum session time of '{}', forcing restart.", (Object)maximumSessionDuration);
                return true;
            }
            stopWatch.start();
        }
        return false;
    }

    protected boolean checkLogSwitchOccurredAndUpdate() throws SQLException {
        List sequences = (List)this.jdbcConnection.queryAndMap(SqlUtils.currentRedoLogSequenceQuery(), rs -> {
            ArrayList<BigInteger> results = new ArrayList<BigInteger>();
            while (rs.next()) {
                results.add(new BigInteger(rs.getString(1)));
            }
            return results;
        });
        if (!sequences.equals(this.currentRedoLogSequences)) {
            LOGGER.debug("Current log sequence(s) is now {}, was {}", (Object)sequences, this.currentRedoLogSequences);
            this.currentRedoLogSequences = sequences;
            this.metrics.setSwitchCount((Integer)this.jdbcConnection.queryAndMap(SqlUtils.switchHistoryQuery(this.archiveDestinationName), rs -> rs.next() ? rs.getInt(2) : 0));
            return true;
        }
        return false;
    }

    protected void prepareLogsForMining(boolean postMiningSessionEnded, Scn lowerBoundsScn) throws SQLException {
        if (!this.useContinuousMining) {
            this.sessionContext.removeAllLogFilesFromSession();
        }
        if (!(postMiningSessionEnded && this.useContinuousMining || !this.isUsingCatalogInRedoStrategy())) {
            this.sessionContext.writeDataDictionaryToRedoLogs();
        }
        this.currentLogFiles = this.logCollector.getLogs(lowerBoundsScn);
        if (!this.useContinuousMining) {
            for (LogFile logFile : this.currentLogFiles) {
                this.sessionContext.addLogFile(logFile.getFileName());
            }
            this.currentRedoLogSequences = this.currentLogFiles.stream().filter(LogFile::isCurrent).map(LogFile::getSequence).toList();
        }
        this.metrics.setMinedLogFileNames(this.currentLogFiles.stream().map(LogFile::getFileName).collect(Collectors.toSet()));
        this.metrics.setCurrentLogFileNames(this.currentLogFiles.stream().filter(LogFile::isCurrent).map(LogFile::getFileName).collect(Collectors.toSet()));
        LOGGER.trace("Current redo log filenames: {}", (Object)String.join((CharSequence)", ", this.metrics.getCurrentLogFileNames()));
        this.metrics.setRedoLogStatuses((Map)this.jdbcConnection.queryAndMap(SqlUtils.redoLogStatusQuery(), rs -> {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            while (rs.next()) {
                results.put(rs.getString(1), rs.getString(2));
            }
            return results;
        }));
    }

    protected boolean startMiningSession(Scn startScn, Scn endScn, int attempts) throws SQLException {
        try {
            Scn newEndScn;
            if (this.connectorConfig.isArchiveLogOnlyMode() && !(newEndScn = this.getMinNextScnAcrossAllThreadMaxNextScnValues()).equals(endScn)) {
                LOGGER.debug("Adjusted archive log only mode upper bounds from {} to {}.", (Object)endScn, (Object)newEndScn);
                endScn = newEndScn;
            }
            LOGGER.debug("Starting mining session [startScn={}, endScn={}, strategy={}, attempts={}/{}]", new Object[]{startScn, endScn, this.connectorConfig.getLogMiningStrategy(), attempts, 5});
            this.metrics.setLastMiningSessionRange(startScn, endScn);
            this.sessionContext.startSession(startScn, endScn, this.isUsingCommittedDataOnly());
            this.metrics.setLastMiningSessionStartDuration(this.sessionContext.getLastSessionStartTime());
            return true;
        }
        catch (Exception e) {
            LogMinerDatabaseStateWriter.writeLogMinerStartParameters(this.jdbcConnection);
            if (e instanceof RetriableLogMinerException) {
                if (attempts <= 5) {
                    LOGGER.warn("Failed to start Oracle LogMiner session, retrying...");
                    return false;
                }
                LOGGER.error("Failed to start Oracle LogMiner after '{}' attempts.", (Object)5, (Object)e);
                LogMinerDatabaseStateWriter.writeLogMinerLogFailures(this.jdbcConnection);
            }
            LOGGER.error("Got exception when starting mining session.", (Throwable)e);
            LogMinerDatabaseStateWriter.write(this.jdbcConnection);
            throw e;
        }
    }

    protected void endMiningSession() throws SQLException {
        this.sessionContext.endMiningSession();
    }

    protected void captureJdbcSessionMemoryStatistics() throws SQLException {
        long sessionUserGlobalAreaMemory = this.jdbcConnection.getSessionStatisticByName("session uga memory");
        long sessionUserGlobalAreaMaxMemory = this.jdbcConnection.getSessionStatisticByName("session uga memory max");
        this.metrics.setUserGlobalAreaMemory(sessionUserGlobalAreaMemory, sessionUserGlobalAreaMaxMemory);
        long sessionProcessGlobalAreaMemory = this.jdbcConnection.getSessionStatisticByName("session pga memory");
        long sessionProcessGlobalAreaMaxMemory = this.jdbcConnection.getSessionStatisticByName("session pga memory max");
        this.metrics.setProcessGlobalAreaMemory(sessionProcessGlobalAreaMemory, sessionProcessGlobalAreaMaxMemory);
        if (LOGGER.isDebugEnabled()) {
            DecimalFormat format = new DecimalFormat("#.##");
            LOGGER.debug("Oracle Session UGA {}MB (max = {}MB), PGA {}MB (max = {}MB)", new Object[]{format.format((float)sessionUserGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionUserGlobalAreaMaxMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMaxMemory / 1024.0f / 1024.0f)});
        }
    }

    protected void dispatchSchemaChangeEventInternal(LogMinerEventRow event) throws InterruptedException {
        TableId tableId = event.getTableId();
        this.getOffsetContext().setEventScn(event.getScn());
        this.getOffsetContext().setRedoThread(event.getThread());
        this.getOffsetContext().setRsId(event.getRsId());
        this.getOffsetContext().setRowId("");
        this.getOffsetContext().setTransactionSequence(event.getTransactionSequence());
        this.getEventDispatcher().dispatchSchemaChangeEvent((Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.getConfig(), this.getPartition(), this.getOffsetContext(), tableId, tableId.catalog(), tableId.schema(), event.getObjectId(), event.getObjectId(), event.getRedoSql(), this.getSchema(), event.getChangeTime(), this.getMetrics(), () -> this.handleTruncateEvent(event)));
        if (this.isUsingHybridStrategy()) {
            this.reconstructColumnDmlParser.removeTableFromCache(tableId);
        }
        this.getBatchMetrics().schemaChangeObserved();
    }

    protected void dispatchDataChangeEventInternal(LogMinerEventRow event, Table table) throws InterruptedException {
        LogMinerDmlEntry parsedEvent = this.parseDmlStatement(event, table);
        if (parsedEvent != null) {
            parsedEvent.setObjectName(event.getTableName());
            parsedEvent.setObjectOwner(event.getTablespaceName());
            this.enqueueEvent(event, this.getConfig().isLogMiningIncludeRedoSql() ? new RedoSqlDmlEvent(event, parsedEvent, event.getRedoSql()) : new DmlEvent(event, parsedEvent));
            this.getMetrics().incrementTotalChangesCount();
        }
    }

    protected boolean isEventIncludedInSnapshot(LogMinerEventRow event) {
        Map<String, Scn> snapshotPendingTrxs;
        if (!(event.getScn().compareTo(this.getOffsetContext().getSnapshotScn()) >= 0 || (snapshotPendingTrxs = this.getOffsetContext().getSnapshotPendingTransactions()) != null && snapshotPendingTrxs.containsKey(event.getTransactionId()))) {
            LOGGER.info("Skipping event {} (SCN {}) because it is already included by the initial snapshot", (Object)event.getEventType(), (Object)event.getScn());
            return true;
        }
        return false;
    }

    protected boolean isNonSchemaChangeEventSkipped(LogMinerEventRow event) {
        TableId tableId = event.getTableId();
        if (tableId != null && !EventType.DDL.equals((Object)event.getEventType()) && !this.tableFilter.isIncluded(tableId) && this.isNonIncludedTableSkipped(event)) {
            LOGGER.debug("Skipping change associated with table '{}' which does not match filters.", (Object)tableId);
            return true;
        }
        return false;
    }

    protected boolean isSchemaChangeEventSkipped(LogMinerEventRow event) {
        TableId tableId = event.getTableId();
        boolean skipEvent = this.getConfig().getLogMiningSchemaChangesUsernameExcludes().stream().anyMatch(name -> name.equalsIgnoreCase(event.getUserName()));
        if (skipEvent) {
            Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"User '{}' is in schema change exclusions, DDL skipped.", (Object[])new Object[]{event.getUserName()});
            return true;
        }
        if (!Strings.isNullOrEmpty((String)event.getInfo()) && event.getInfo().startsWith("INTERNAL DDL")) {
            Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Internal DDL skipped.", (Object[])new Object[0]);
            return true;
        }
        if (tableId != null && this.getSchema().storeOnlyCapturedTables() && !this.tableFilter.isIncluded(tableId)) {
            Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"Skipped DDL associated with table '{}' because schema history only stores included tables.", (Object[])new Object[]{tableId});
            return true;
        }
        if (this.getOffsetContext().getCommitScn().hasEventScnBeenHandled(event)) {
            Scn commitScn = this.getOffsetContext().getCommitScn().getCommitScnForRedoThread(event.getThread());
            LOGGER.trace("DDL skipped with SCN {} <= Commit SCN {} for thread {}: {}", new Object[]{event.getScn(), commitScn, event.getRowId(), Loggings.maybeRedactSensitiveData((Object)event)});
            return true;
        }
        return tableId == null;
    }

    protected boolean isTableKnown(TableId tableId) {
        return !tableId.table().equalsIgnoreCase("UNKNOWN");
    }

    protected LogMinerDmlEntry parseDmlStatement(LogMinerEventRow event, Table table) {
        Instant parseStartTime = Instant.now();
        try {
            LogMinerDmlParser parser = event.hasErrorStatus() && !Strings.isNullOrBlank((String)event.getInfo()) && this.isUsingHybridStrategy() ? this.reconstructColumnDmlParser : this.dmlParser;
            LogMinerDmlEntry parsedEvent = parser.parse(event.getRedoSql(), table);
            if (parsedEvent.getOldValues().length == 0) {
                switch (parsedEvent.getEventType()) {
                    case UPDATE: 
                    case DELETE: {
                        Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)event, (String)"The DML event in transaction {} at SCN {} contained no before state", (Object[])new Object[]{event.getTransactionId(), event.getScn()});
                        this.getMetrics().incrementWarningCount();
                    }
                }
            }
            LogMinerDmlEntry logMinerDmlEntry = parsedEvent;
            this.getMetrics().setLastParseTimeDuration(Duration.between(parseStartTime, Instant.now()));
            return logMinerDmlEntry;
        }
        catch (DmlParserException e) {
            try {
                try {
                    throw new DmlParserException(String.format("DML statement couldn't be parsed. Please open a Jira issue with the statement '%s'.", event.getRedoSql()), (Throwable)((Object)e));
                }
                catch (Throwable throwable) {
                    this.getMetrics().setLastParseTimeDuration(Duration.between(parseStartTime, Instant.now()));
                    throw throwable;
                }
            }
            catch (DmlParserException e2) {
                this.notifyEventProcessingFailure(event, (RuntimeException)((Object)e2));
                return null;
            }
        }
    }

    protected LogMinerDmlEntry parseTruncateEvent(LogMinerEventRow event) {
        LogMinerDmlEntry parsedEvent = LogMinerDmlEntryImpl.forValuelessDdl();
        parsedEvent.setObjectName(event.getTableName());
        parsedEvent.setObjectOwner(event.getTablespaceName());
        return parsedEvent;
    }

    protected void notifyEventProcessingFailure(LogMinerEventRow event, RuntimeException cause) {
        switch (this.getConfig().getEventProcessingFailureHandlingMode()) {
            case FAIL: {
                String message = String.format("Oracle LogMiner is unable to re-construct the SQL for '%s' event with SCN %s", new Object[]{event.getEventType(), event.getScn()});
                Loggings.logErrorAndTraceRecord((Logger)LOGGER, (Object)event, (String)message, (Object[])new Object[0]);
                throw cause != null ? cause : new DebeziumException(message);
            }
            case WARN: {
                Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)event, (String)"An {} event with SCN {} cannot be parsed. This event will be ignored and skipped.", (Object[])new Object[]{event.getEventType(), event.getScn()});
                break;
            }
            default: {
                Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)event, (String)"An {} event with SCN {} cannot be parsed. This event will be ignored and skipped.", (Object[])new Object[]{event.getEventType(), event.getScn()});
            }
        }
    }

    protected Table getTableForDataEvent(LogMinerEventRow event) throws SQLException, InterruptedException {
        TableId tableId = this.getTableIdForDataEvent(event);
        if (tableId != null) {
            Table table = this.getSchema().tableFor(tableId);
            if (table != null) {
                return table;
            }
            if (this.tableFilter.isIncluded(tableId)) {
                return this.dispatchSchemaChangeEventAndGetTableForNewConfiguredTable(tableId);
            }
        }
        return null;
    }

    protected TableId getTableIdForDataEvent(LogMinerEventRow event) throws SQLException {
        TableId tableId = event.getTableId();
        if (tableId != null && this.isUsingHybridStrategy()) {
            if (tableId.table().startsWith("BIN$")) {
                try (OracleConnection connection = new OracleConnection(this.getConfig());){
                    TableId tableId2 = (TableId)connection.prepareQueryAndMap("SELECT OWNER, ORIGINAL_NAME FROM DBA_RECYCLEBIN WHERE OBJECT_NAME=?", ps -> ps.setString(1, tableId.table()), rs -> {
                        if (rs.next()) {
                            return new TableId(tableId.catalog(), rs.getString(1), rs.getString(2));
                        }
                        return tableId;
                    });
                    return tableId2;
                }
            }
            if (!this.isTableKnown(tableId)) {
                TableId resolvedTableId = this.getSchema().getTableIdByObjectId(event.getObjectId(), event.getDataObjectId());
                if (resolvedTableId != null) {
                    return resolvedTableId;
                }
                throw new DebeziumException("Failed to resolve UNKNOWN table name by object id lookup");
            }
        }
        return tableId;
    }

    protected boolean isNonIncludedTableSkipped(LogMinerEventRow event) {
        if (this.isUsingHybridStrategy() && this.isTableLookupByObjectIdRequired(event)) {
            LOGGER.trace("Found DML for dropped table in history with object-id based table name {}.", (Object)event.getTableId().table());
            TableId tableId = this.getSchema().getTableIdByObjectId(event.getObjectId(), null);
            if (tableId != null) {
                event.setTableId(tableId);
            }
            return !this.tableFilter.isIncluded(event.getTableId());
        }
        return true;
    }

    protected boolean isUserNameSkipped(String userName) {
        if (!Strings.isNullOrEmpty((String)userName)) {
            Set<String> userNameExcludes = this.connectorConfig.getLogMiningUsernameExcludes();
            Set<String> userNameIncludes = this.connectorConfig.getLogMiningUsernameIncludes();
            if (userNameExcludes.contains(userName)) {
                LOGGER.debug("Skipped transaction with excluded username {}", (Object)userName);
                return true;
            }
            if (!userNameIncludes.isEmpty() && !userNameIncludes.contains(userName)) {
                LOGGER.debug("Skipped transaction with username {}", (Object)userName);
                return true;
            }
        }
        return false;
    }

    protected boolean isClientIdSkipped(String clientId) {
        if (!Strings.isNullOrEmpty((String)clientId)) {
            Set<String> clientIdExcludes = this.connectorConfig.getLogMiningClientIdExcludes();
            Set<String> clientIdIncludes = this.connectorConfig.getLogMiningClientIdIncludes();
            if (clientIdExcludes.contains(clientId)) {
                LOGGER.debug("Skipped transaction with excluded client id {}", (Object)clientId);
                return true;
            }
            if (!clientIdIncludes.isEmpty() && !clientIdIncludes.contains(clientId)) {
                LOGGER.debug("Skipped transaction with client id {}", (Object)clientId);
                return true;
            }
        }
        return false;
    }

    protected void updateCommitMetrics(LogMinerEventRow event, Duration commitDuration, int eventCount) {
        this.getMetrics().incrementCommittedTransactionCount();
        this.getMetrics().setCommitScn(event.getScn());
        this.getMetrics().setOffsetScn(this.getOffsetContext().getScn());
        this.getMetrics().setLastCommitDuration(commitDuration);
        this.getMetrics().setLastCommitEventCount(eventCount);
    }

    private boolean isTableLookupByObjectIdRequired(LogMinerEventRow event) {
        String tableName = event.getTableId().table();
        if (tableName.startsWith("OBJ# ")) {
            return true;
        }
        return tableName.startsWith("BIN$") && tableName.endsWith("==$0") && tableName.length() == 30;
    }

    protected Table dispatchSchemaChangeEventAndGetTableForNewConfiguredTable(TableId tableId) throws SQLException, InterruptedException {
        Table table;
        LOGGER.warn("Obtaining schema for table {}, which should already be loaded.", (Object)tableId);
        OracleConnection connection = new OracleConnection(this.getConfig());
        try {
            connection.setAutoCommit(false);
            if (this.isUsingPluggableDatabase()) {
                connection.setSessionToPdb(this.getConfig().getPdbName());
            }
            this.getBatchMetrics().tableMetadataQueryObserved();
            String tableDdl = connection.getTableMetadataDdl(tableId);
            Long objectId = connection.getTableObjectId(tableId);
            Long dataObjectId = connection.getTableDataObjectId(tableId);
            this.getEventDispatcher().dispatchSchemaChangeEvent((Partition)this.getPartition(), (OffsetContext)this.getOffsetContext(), (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.getConfig(), this.getPartition(), this.getOffsetContext(), tableId, tableId.catalog(), tableId.schema(), objectId, dataObjectId, tableDdl, this.getSchema(), Instant.now(), this.getMetrics(), null));
            table = this.getSchema().tableFor(tableId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OracleConnection.NonRelationalTableException e) {
                LOGGER.warn("{} The event will be skipped.", (Object)e.getMessage());
                this.getMetrics().incrementWarningCount();
                return null;
            }
        }
        connection.close();
        return table;
    }

    private void setNlsSessionParameters() throws SQLException {
        String NLS_SESSION_PARAMETERS = "ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9 TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'";
        this.jdbcConnection.executeWithoutCommitting(new String[]{"ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9 TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'"});
        this.jdbcConnection.executeWithoutCommitting(new String[]{"ALTER SESSION SET TIME_ZONE = '00:00'"});
    }

    private void setHashSortArea() throws SQLException {
        long sortAreaSize;
        long hashAreaSize = this.getConfig().getLogMiningHashAreaSize();
        if (hashAreaSize > 0L) {
            LOGGER.debug("Setting LogMiner connection HASH_AREA_SIZE={}", (Object)hashAreaSize);
            this.jdbcConnection.executeWithoutCommitting(new String[]{"ALTER SESSION SET HASH_AREA_SIZE = " + hashAreaSize});
        }
        if ((sortAreaSize = this.getConfig().getLogMiningSortAreaSize().longValue()) > 0L) {
            LOGGER.debug("Setting LogMiner connection SORT_AREA_SIZE={}", (Object)sortAreaSize);
            this.jdbcConnection.executeWithoutCommitting(new String[]{"ALTER SESSION SET SORT_AREA_SIZE = " + sortAreaSize});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseAndTableState() throws SQLException {
        Instant start = Instant.now();
        LOGGER.trace("Checking database and table state, this may take time depending on the size of your schema.");
        try {
            if (this.isUsingPluggableDatabase()) {
                this.jdbcConnection.setSessionToPdb(this.connectorConfig.getPdbName());
            }
            if (!this.isDatabaseAllSupplementalLoggingEnabled()) {
                if (!this.isDatabaseMinSupplementalLoggingEnabled()) {
                    throw new DebeziumException("Supplemental logging not properly configured. Use: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA");
                }
                for (TableId tableId : this.schema.tableIds()) {
                    if (!this.jdbcConnection.isTableExists(tableId)) {
                        LOGGER.warn("Database table '{}' no longer exists, supplemental log check skipped", (Object)tableId);
                    } else if (!this.isTableAllColumnsSupplementalLoggingEnabled(tableId)) {
                        LOGGER.warn("Database table '{}' not configured with supplemental logging \"(ALL) COLUMNS\"; only explicitly changed columns will be captured. Use: ALTER TABLE {}.{} ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS", new Object[]{tableId, tableId.schema(), tableId.table()});
                    }
                    Table table = this.schema.tableFor(tableId);
                    if (table == null) {
                        throw new DebeziumException("Unable to find table in relational model: " + String.valueOf(tableId));
                    }
                    this.checkTableColumnNameLengths(table);
                }
            } else {
                for (TableId tableId : this.schema.tableIds()) {
                    Table table = this.schema.tableFor(tableId);
                    if (table == null) {
                        throw new DebeziumException("Unable to find table in relational model: " + String.valueOf(tableId));
                    }
                    this.checkTableColumnNameLengths(table);
                }
            }
        }
        finally {
            if (this.isUsingPluggableDatabase()) {
                this.jdbcConnection.resetSessionToCdb();
            }
        }
        LOGGER.trace("Database and table state check finished after {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    private boolean isDatabaseAllSupplementalLoggingEnabled() throws SQLException {
        return (Boolean)this.jdbcConnection.queryAndMap(SqlUtils.databaseSupplementalLoggingAllCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isDatabaseMinSupplementalLoggingEnabled() throws SQLException {
        return (Boolean)this.jdbcConnection.queryAndMap(SqlUtils.databaseSupplementalLoggingMinCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isTableAllColumnsSupplementalLoggingEnabled(TableId tableId) throws SQLException {
        return (Boolean)this.jdbcConnection.prepareQueryAndMap(SqlUtils.tableSupplementalLoggingCheckQuery(), ps -> {
            ps.setString(1, tableId.schema());
            ps.setString(2, tableId.table());
        }, rs -> {
            while (rs.next()) {
                if (!"ALL COLUMN LOGGING".equals(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private void checkTableColumnNameLengths(Table table) {
        if (table.id().table().length() > 30) {
            LOGGER.warn("Table '{}' won't be captured by Oracle LogMiner because its name exceeds {} characters.", (Object)table.id().table(), (Object)30);
        }
        for (Column column : table.columns()) {
            if (column.name().length() <= 30) continue;
            LOGGER.warn("Table '{}' won't be captured by Oracle LogMiner because column '{}' exceeds {} characters.", new Object[]{table.id().table(), column.name(), 30});
        }
    }

    private void logOnlineRedoLogSizes() throws SQLException {
        this.jdbcConnection.query("SELECT GROUP#, BYTES FROM V$LOG ORDER BY 1", rs -> {
            LOGGER.info("Redo Log Group Sizes:");
            boolean potentiallySmallLogs = false;
            while (rs.next()) {
                long logSize = rs.getLong(2);
                if (logSize < SMALL_REDO_LOG_WARNING) {
                    potentiallySmallLogs = true;
                }
                LOGGER.info("\tGroup #{}: {} bytes", (Object)rs.getInt(1), (Object)logSize);
            }
            if (this.isUsingCatalogInRedoStrategy() && potentiallySmallLogs) {
                LOGGER.warn("Redo logs may be sized too small using the default mining strategy, consider increasing redo log sizes to a minimum of 500MB.");
            }
        });
    }

    private Scn computeStartScnForFirstMiningSession(Scn firstScn, Scn offsetScn, Scn snapshotScn) {
        Map<String, Scn> snapshotPendingTransactions = this.getOffsetContext().getSnapshotPendingTransactions();
        if (snapshotPendingTransactions == null || snapshotPendingTransactions.isEmpty()) {
            return snapshotScn;
        }
        Scn minScn = snapshotScn;
        for (Map.Entry<String, Scn> entry : snapshotPendingTransactions.entrySet()) {
            String transactionId = entry.getKey();
            Scn scn = entry.getValue();
            LOGGER.info("Transaction {} was pending across snapshot boundary. Start SCN = {}, snapshot SCN = {}", new Object[]{transactionId, scn, offsetScn});
            if (scn.compareTo(firstScn) < 0) {
                LOGGER.warn("Transaction {} was still ongoing while snapshot was taken, but is no longer completely recorded in the archive logs. Events will be lost. Oldest SCN in logs = {}, TX start SCN = {}", new Object[]{transactionId, firstScn, scn});
                minScn = firstScn;
                continue;
            }
            if (scn.compareTo(minScn) >= 0) continue;
            minScn = scn;
        }
        if (this.getOffsetContext().getCommitScn().compareTo(snapshotScn) < 0) {
            LOGGER.info("Setting commit SCN to {} (snapshot SCN - 1) to ensure we don't double-emit events from pre-snapshot transactions.", (Object)snapshotScn.subtract(Scn.ONE));
            this.getOffsetContext().getCommitScn().setCommitScnOnAllThreads(snapshotScn.subtract(Scn.ONE));
        }
        if (minScn.compareTo(offsetScn) <= 0) {
            LOGGER.info("Resetting start SCN from {} (snapshot SCN) to {} (start of oldest complete pending transaction)", (Object)offsetScn, (Object)minScn);
            return minScn.subtract(Scn.ONE);
        }
        return offsetScn;
    }

    private Scn getFirstScnAvailableInLogs() throws SQLException {
        return this.jdbcConnection.getFirstScnInLogs(this.connectorConfig.getArchiveLogRetention(), this.archiveDestinationName).orElseThrow(() -> new DebeziumException("Failed to calculate oldest SCN available in logs"));
    }

    private boolean waitForScnInArchiveLogs(Scn scn) throws SQLException, InterruptedException {
        boolean showMessage = true;
        while (this.context.isRunning() && !this.isScnInArchiveLogs(scn)) {
            if (showMessage) {
                LOGGER.warn("SCN {} is not yet in archive logs, waiting for log switch.", (Object)scn);
                showMessage = false;
            }
            Metronome.sleeper((Duration)this.connectorConfig.getArchiveLogOnlyScnPollTime(), (Clock)this.getClock()).pause();
        }
        if (!this.context.isRunning()) {
            return false;
        }
        if (!showMessage) {
            LOGGER.info("SCN {} is now available in archive logs, log mining session resumed.", (Object)scn);
        }
        return true;
    }

    private boolean isScnInArchiveLogs(Scn scn) throws SQLException {
        try {
            return this.logCollector.getLogsForOffsetScn(scn).stream().anyMatch(log -> log.isScnInLogFileRange(scn) && log.isArchive());
        }
        catch (LogFileNotFoundException e) {
            return false;
        }
    }

    private Optional<Scn> calculateDeviatedEndScn(Scn lowerboundsScn, Scn upperboundsScn, Duration deviation) {
        if (this.connectorConfig.isArchiveLogOnlyMode()) {
            return Optional.of(upperboundsScn);
        }
        Optional<Scn> calculatedDeviatedEndScn = this.getDeviatedMaxScn(upperboundsScn, deviation);
        if (calculatedDeviatedEndScn.isEmpty() || calculatedDeviatedEndScn.get().isNull()) {
            LOGGER.warn("Mining session end SCN deviation calculation is outside undo space, using upperbounds {}. If this continues, consider lowering the value of the '{}' configuration property.", (Object)upperboundsScn, (Object)OracleConnectorConfig.LOG_MINING_MAX_SCN_DEVIATION_MS.name());
            return Optional.of(upperboundsScn);
        }
        if (calculatedDeviatedEndScn.get().compareTo(lowerboundsScn) <= 0) {
            LOGGER.debug("Mining session end SCN deviation as {}, outside of mining range, recalculating.", (Object)calculatedDeviatedEndScn.get());
            return Optional.empty();
        }
        return calculatedDeviatedEndScn;
    }

    private Optional<Scn> getDeviatedMaxScn(Scn upperboundsScn, Duration deviation) {
        try {
            Scn currentScn = this.jdbcConnection.getCurrentScn();
            Optional<Instant> currentInstant = this.jdbcConnection.getScnToTimestamp(currentScn);
            Optional<Instant> upperInstant = this.jdbcConnection.getScnToTimestamp(upperboundsScn);
            if (currentInstant.isPresent() && upperInstant.isPresent() && Duration.between(upperInstant.get(), currentInstant.get()).compareTo(deviation) >= 0) {
                LOGGER.trace("Upper bounds {} is within deviation period, using it.", (Object)upperboundsScn);
                return Optional.of(upperboundsScn);
            }
            return Optional.of(this.jdbcConnection.getScnAdjustedByTime(upperboundsScn, deviation));
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to calculate deviated max SCN value from {}.", (Object)upperboundsScn);
            return Optional.empty();
        }
    }

    private void incrementBatchSize() {
        int batchSizeMax = this.connectorConfig.getLogMiningBatchSizeMax();
        int batchSizeIncrement = this.connectorConfig.getLogMiningBatchSizeIncrement();
        if (this.currentBatchSize < batchSizeMax) {
            int previousBatchSize = this.currentBatchSize;
            this.currentBatchSize = Math.min(this.currentBatchSize + batchSizeIncrement, batchSizeMax);
            this.metrics.setBatchSize(this.currentBatchSize);
            if (previousBatchSize != this.currentBatchSize && this.currentBatchSize == batchSizeMax) {
                LOGGER.debug("The connector is now using the maximum batch size {}.", (Object)this.currentBatchSize);
            } else if (previousBatchSize != this.currentBatchSize) {
                LOGGER.debug("Updated batch size window, using batch size {}", (Object)this.currentBatchSize);
            }
        }
    }

    private void incrementSleepTime() {
        long sleepTimeMax = this.connectorConfig.getLogMiningSleepTimeMax().toMillis();
        long sleepTimeIncrement = this.connectorConfig.getLogMiningSleepTimeIncrement().toMillis();
        if (this.currentSleepTime < sleepTimeMax) {
            long previousSleepTime = this.currentSleepTime;
            this.currentSleepTime = Math.min(this.currentSleepTime + sleepTimeIncrement, sleepTimeMax);
            this.metrics.setSleepTime(this.currentSleepTime);
            if (previousSleepTime != this.currentSleepTime) {
                if (this.currentSleepTime == sleepTimeMax) {
                    LOGGER.debug("The connector is now using the maximum sleep time {}.", (Object)this.currentSleepTime);
                } else {
                    LOGGER.debug("Update sleep time, using {}", (Object)this.currentBatchSize);
                }
            }
        }
    }

    private void decrementBatchSize() {
        int batchSizeMin = this.connectorConfig.getLogMiningBatchSizeMin();
        int batchSizeIncrement = this.connectorConfig.getLogMiningBatchSizeIncrement();
        if (this.currentBatchSize > batchSizeMin) {
            int previousBatchSize = this.currentBatchSize;
            this.currentBatchSize = Math.max(this.currentBatchSize - batchSizeIncrement, batchSizeMin);
            this.metrics.setBatchSize(this.currentBatchSize);
            if (previousBatchSize != this.currentBatchSize && this.currentBatchSize == batchSizeMin) {
                LOGGER.debug("The connector is now using the minimum batch size {}.", (Object)this.currentBatchSize);
            } else if (previousBatchSize != this.currentBatchSize) {
                LOGGER.debug("Updated batch size window, using batch size {}", (Object)this.currentBatchSize);
            }
        }
    }

    private void decrementSleepTime() {
        long sleepTimeMin = this.connectorConfig.getLogMiningSleepTimeMin().toMillis();
        long sleepTimeIncrement = this.connectorConfig.getLogMiningSleepTimeIncrement().toMillis();
        if (this.currentSleepTime > sleepTimeMin) {
            long previousSleepTime = this.currentSleepTime;
            this.currentSleepTime = Math.max(this.currentSleepTime - sleepTimeIncrement, sleepTimeMin);
            this.metrics.setSleepTime(this.currentSleepTime);
            if (previousSleepTime != this.currentSleepTime) {
                if (this.currentSleepTime == sleepTimeMin) {
                    LOGGER.debug("The connector is now using the minimum sleep time {}.", (Object)this.currentSleepTime);
                } else {
                    LOGGER.debug("Update sleep time, using {}", (Object)this.currentBatchSize);
                }
            }
        }
    }

    private boolean isNoSqlRedoForTemporaryTable(LogMinerEventRow event) {
        return NO_REDO_SQL_FOR_TEMPORARY_TABLES.equals(event.getRedoSql());
    }

    private OracleOffsetContext emptyContext() {
        return OracleOffsetContext.create().logicalName(this.connectorConfig).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    private Scn getMinNextScnAcrossAllThreadMaxNextScnValues() {
        return (Scn)this.getCurrentLogFiles().stream().filter(LogFile::isArchive).collect(Collectors.groupingBy(LogFile::getThread, Collectors.mapping(LogFile::getNextScn, Collectors.maxBy(Scn::compareTo)))).values().stream().flatMap(Optional::stream).min(Scn::compareTo).orElseThrow(() -> new DebeziumException("Failed to resolve archive logs upper bounds"));
    }
}

