/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private final Tables.TableFilter tableFilter;
    private final OracleValueConverters converters;
    private final DataTypeResolver dataTypeResolver = this.initializeDataTypeResolver();
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters) {
        this(true, valueConverters, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters, Tables.TableFilter tableFilter) {
        this(true, valueConverters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        this(throwErrorsFromTreeWalk, false, false, converters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    public DdlChanges parse(String ddlContent, Tables databaseTables) {
        Object strippedDdl = ddlContent.strip();
        if (!((String)strippedDdl).endsWith(";")) {
            strippedDdl = (String)strippedDdl + ";";
        }
        return super.parse((String)strippedDdl, databaseTables);
    }

    public ParseTree parseTree(PlSqlParser parser) {
        return parser.sql_script();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser((TokenStream)commonTokenStream);
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    public DataTypeResolver dataTypeResolver() {
        return this.dataTypeResolver;
    }

    private DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, new Integer[]{776}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{768}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1705}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1230}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{379}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1229}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{359}), new DataTypeResolver.DataTypeEntry(-102, new Integer[]{2107}), new DataTypeResolver.DataTypeEntry(-101, new Integer[]{2107}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{2107}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{2258}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{2259}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{1234}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{196}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{1007}), new DataTypeResolver.DataTypeEntry(100, new Integer[]{128}), new DataTypeResolver.DataTypeEntry(101, new Integer[]{125}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{606}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{1508}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{142}), new DataTypeResolver.DataTypeEntry(2005, new Integer[]{215})));
        return dataTypeResolverBuilder.build();
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public OracleValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

