/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class TcpConnection
extends Connection {
    protected final Socket sock;
    protected final ReentrantLock send_lock = new ReentrantLock();
    protected OutputStream out;
    protected DataInputStream in;
    protected volatile Receiver receiver;
    protected final AtomicInteger writers = new AtomicInteger(0);
    protected volatile boolean connected;
    protected final byte[] length_buf = new byte[4];

    public TcpConnection(Address peer_addr, TcpBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
        }
        this.peer_addr = peer_addr;
        this.sock = server.socketFactory().createSocket("jgroups.tcp.sock");
        this.setSocketParameters(this.sock);
        this.last_access = this.getTimestamp();
        if (this.sock instanceof SSLSocket) {
            this.sock.setSoLinger(true, 0);
        }
    }

    public TcpConnection(Socket s, TcpServer server) throws Exception {
        this.sock = s;
        this.server = server;
        if (s == null) {
            throw new IllegalArgumentException("Invalid parameter s=" + s);
        }
        this.setSocketParameters(s);
        this.out = this.createDataOutputStream(s.getOutputStream());
        this.in = this.createDataInputStream(s.getInputStream());
        this.connected = this.sock.isConnected();
        this.peer_addr = server.usePeerConnections() ? this.readPeerAddress(s) : new IpAddress((InetSocketAddress)s.getRemoteSocketAddress());
        this.last_access = this.getTimestamp();
        if (this.sock instanceof SSLSocket) {
            this.sock.setSoLinger(true, 0);
        }
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = this.sock != null ? (InetSocketAddress)this.sock.getLocalSocketAddress() : null;
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    protected String getSockAddress() {
        StringBuilder sb = new StringBuilder();
        if (this.sock != null) {
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
        }
        return sb.toString();
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
        try {
            if (!this.server.defer_client_binding) {
                this.sock.bind(new InetSocketAddress(this.server.client_bind_addr, this.server.client_bind_port));
            }
            Util.connect(this.sock, destAddr, this.server.sock_conn_timeout);
            if (this.sock.getLocalSocketAddress() != null && this.sock.getLocalSocketAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
            }
            if (this.sock instanceof SSLSocket) {
                ((SSLSocket)this.sock).startHandshake();
            }
            this.out = this.createDataOutputStream(this.sock.getOutputStream());
            this.in = this.createDataInputStream(this.sock.getInputStream());
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            }
            this.connected = this.sock.isConnected();
        }
        catch (Exception t) {
            Util.close((Closeable)this.sock);
            this.connected = false;
            throw t;
        }
    }

    @Override
    public void start() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.receiver = new Receiver(this.server.factory).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        if (this.out == null) {
            return;
        }
        this.writers.incrementAndGet();
        this.send_lock.lock();
        try {
            this.doSend(data, offset, length);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.send_lock.unlock();
            if (this.writers.decrementAndGet() == 0) {
                this.flush();
            }
        }
    }

    @Override
    public void send(ByteBuffer buf) throws Exception {
        if (buf == null) {
            return;
        }
        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
        int len = buf.remaining();
        if (!buf.isDirect()) {
            this.send(buf.array(), offset, len);
        } else {
            byte[] tmp = new byte[len];
            buf.get(tmp, 0, len);
            this.send(tmp, 0, len);
        }
    }

    protected void doSend(byte[] data, int offset, int length) throws Exception {
        this.doSend(data, offset, length, false);
    }

    protected void doSend(byte[] data, int offset, int length, boolean flush) throws Exception {
        Bits.writeInt(length, this.length_buf, 0);
        this.out.write(this.length_buf, 0, this.length_buf.length);
        this.out.write(data, offset, length);
        if (flush) {
            this.out.flush();
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected OutputStream createDataOutputStream(OutputStream out) {
        int size = ((TcpBaseServer)this.server).getBufferedOutputStreamSize();
        return size == 0 ? out : new BufferedOutputStream(out, size);
    }

    protected DataInputStream createDataInputStream(InputStream in) {
        int size = ((TcpBaseServer)this.server).getBufferedInputStreamSize();
        return size == 0 ? new DataInputStream(in) : new DataInputStream(new BufferedInputStream(in, size));
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            if (this.server.send_buf_size > 0) {
                client_sock.setSendBufferSize(this.server.send_buf_size);
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting send buffer to %d bytes: %s", this.server.local_addr, this.server.send_buf_size, ex);
        }
        try {
            if (this.server.recv_buf_size > 0) {
                client_sock.setReceiveBufferSize(this.server.recv_buf_size);
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting receive buffer to %d bytes: %s", this.server.local_addr, this.server.recv_buf_size, ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcp_nodelay);
        if (this.server.linger > 0) {
            client_sock.setSoLinger(true, this.server.linger);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            int addr_size = local_addr.serializedSize();
            ByteArrayDataOutputStream os = new ByteArrayDataOutputStream(addr_size + 4 + cookie.length);
            os.write(cookie, 0, cookie.length);
            os.writeShort(Version.version);
            os.writeShort(addr_size);
            local_addr.writeTo(os);
            this.out.write(os.buffer(), 0, os.position());
            this.out.flush();
        }
        catch (Exception ex) {
            this.server.socket_factory.close(this.sock);
            this.connected = false;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address readPeerAddress(Socket client_sock) throws Exception {
        int timeout = client_sock.getSoTimeout();
        client_sock.setSoTimeout(((TcpBaseServer)this.server).peerAddressReadTimeout());
        try {
            byte[] input_cookie = new byte[cookie.length];
            this.in.readFully(input_cookie, 0, input_cookie.length);
            if (!Arrays.equals(cookie, input_cookie)) {
                throw new SocketException(String.format("%s: BaseServer.TcpConnection.readPeerAddress(): cookie sent by %s:%d does not match own cookie; terminating connection", this.server.localAddress(), client_sock.getInetAddress(), client_sock.getPort()));
            }
            short version = this.in.readShort();
            if (!Version.isBinaryCompatible(version)) {
                throw new IOException("packet from " + client_sock.getInetAddress() + ":" + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
            }
            this.in.readShort();
            IpAddress client_peer_addr = new IpAddress();
            client_peer_addr.readFrom(this.in);
            this.updateLastAccessed();
            IpAddress ipAddress = client_peer_addr;
            return ipAddress;
        }
        finally {
            client_sock.setSoTimeout(timeout);
        }
    }

    public String toString() {
        Socket tmp_sock = this.sock;
        if (tmp_sock == null) {
            return "<null socket>";
        }
        InetAddress local = tmp_sock.getLocalAddress();
        InetAddress remote = tmp_sock.getInetAddress();
        String l = local != null ? Util.shortName(local) : "<null>";
        String r = remote != null ? Util.shortName(remote) : "<null>";
        return String.format("%s:%s --> %s:%s (%d secs old) [%s]", l, tmp_sock.getLocalPort(), r, tmp_sock.getPort(), TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status());
    }

    @Override
    public String status() {
        if (this.sock == null) {
            return "n/a";
        }
        if (this.isClosed()) {
            return "closed";
        }
        if (this.isConnected()) {
            return "connected";
        }
        return "open";
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.sock == null || this.sock.isClosed();
    }

    @Override
    public void close() throws IOException {
        Util.close((Closeable)this.sock);
        this.send_lock.lock();
        try {
            if (this.receiver != null) {
                this.receiver.stop();
                this.receiver = null;
            }
            Util.close(this.out, this.in);
        }
        finally {
            this.connected = false;
            this.send_lock.unlock();
        }
    }

    protected class Receiver
    implements Runnable {
        protected final Thread recv;
        protected volatile boolean receiving = true;
        protected byte[] buffer;

        public Receiver(ThreadFactory f) {
            this.recv = f.newThread(this, "Connection.Receiver [" + TcpConnection.this.getSockAddress() + "]");
        }

        public Receiver start() {
            this.receiving = true;
            this.recv.start();
            return this;
        }

        public Receiver stop() {
            this.receiving = false;
            return this;
        }

        public boolean isRunning() {
            return this.receiving;
        }

        public boolean canRun() {
            return this.isRunning() && TcpConnection.this.isConnected();
        }

        @Override
        public void run() {
            try {
                while (this.canRun()) {
                    int len = TcpConnection.this.in.readInt();
                    TcpConnection.this.server.receive(TcpConnection.this.peer_addr, TcpConnection.this.in, len);
                    TcpConnection.this.updateLastAccessed();
                }
            }
            catch (EOFException | SocketException len) {
            }
            catch (Exception e) {
                if (e instanceof SSLException && e.getMessage().contains("Socket closed")) {
                } else if (e instanceof SSLHandshakeException && e.getCause() instanceof EOFException) {
                } else if (TcpConnection.this.server.logDetails()) {
                    TcpConnection.this.server.log.warn("failed handling message", e);
                } else {
                    TcpConnection.this.server.log.warn("failed handling message: " + e);
                }
            }
            finally {
                TcpConnection.this.server.notifyConnectionClosed(TcpConnection.this);
            }
        }
    }
}

