/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.util.Arrays;
import java.util.Set;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.impl.internal.store.shared.SharedStorageProvider;
import org.ehcache.impl.internal.store.shared.store.SharedStoreProvider;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={SharedStorageProvider.class})
@OptionalServiceDependencies(value={"org.ehcache.core.spi.service.StatisticsService"})
public abstract class AbstractSharedTierProvider
implements Service {
    protected SharedStorageProvider sharedStorageProvider;
    protected StatisticsService statisticsService;

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.sharedStorageProvider = serviceProvider.getService(SharedStorageProvider.class);
        this.statisticsService = serviceProvider.getService(StatisticsService.class);
    }

    @Override
    public void stop() {
        this.sharedStorageProvider = null;
        this.statisticsService = null;
    }

    protected void associateStoreStatsWithPartition(Object toAssociate, Object parent) {
        if (this.statisticsService != null) {
            this.statisticsService.registerWithParent(toAssociate, parent);
        }
    }

    protected <T> int rank(Class<T> type, Set<ResourceType<?>> resourceTypes) {
        if (resourceTypes.size() == 1) {
            ResourceType<?> resourceType = resourceTypes.iterator().next();
            if (resourceType instanceof ResourceType.SharedResource && this.sharedStorageProvider.supports(type, ((ResourceType.SharedResource)resourceType).getResourceType())) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    protected static ResourceType.SharedResource<?> assertResourceIsShareable(Set<ResourceType<?>> resourceTypes) {
        if (resourceTypes.size() == 1) {
            ResourceType<?> resourceType = resourceTypes.iterator().next();
            if (resourceType instanceof ResourceType.SharedResource) {
                return (ResourceType.SharedResource)resourceType;
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    protected String extractAlias(ServiceConfiguration<?, ?>[] serviceConfigs) {
        return Arrays.stream(serviceConfigs).filter(SharedStoreProvider.SharedPersistentSpaceIdentifier.class::isInstance).map(SharedStoreProvider.SharedPersistentSpaceIdentifier.class::cast).findFirst().map(SharedStoreProvider.SharedPersistentSpaceIdentifier::getName).orElse(null);
    }
}

